/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *      Author: Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

/*
 * Multi-Byte String WLabel
 */

#ifndef iv_wlabel_h
#define iv_wlabel_h

#include <InterViews/boolean.h>
#include <InterViews/glyph.h>
#include <NLS/enter-scope.h>

class Color;
class Font;
class FontSet;
class WString;

#include <InterViews/_enter.h>

class WLabel : public Glyph {
  public:
    WLabel(const WString&, const FontSet *, const Color*);
    virtual ~WLabel();

  public:
    virtual void request(Requisition&) const;
    virtual void allocate(Canvas*, const Allocation&, Extension&);
    virtual void draw(Canvas*, const Allocation&) const;
    virtual void pick(Canvas*, const Allocation&, int depth, Hit&);

    // access functions
    const WString* string () const  { return text_; }
    const FontSet* font () const      { return fontset_; }
    const Color* color () const    { return color_; }
    Coord ascent () const   { return ascent_; }
    Coord descent () const  { return descent_; }
    const Coord* charWidths () const  { return widths_; }


  private:
    WString* text_;
    const FontSet* fontset_;
    const Color* color_;
    Coord left_;
    Coord right_;
    Coord ascent_;
    Coord descent_;
    Coord width_;
    Coord *widths_;
};

#include <InterViews/_leave.h>

#endif
