//<copyright>
//
// Copyright (c) 1992,93,94,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        sdfcam.C
//
// Purpose:     implementation of class SDFCamera
//
// Created:     18 Mar 92   Michael Hofer and Michael Pichler
//
// Changed:      4 May 95   Michael Pichler
//
// $Id: sdfcam.C,v 1.3 1997/02/25 17:03:58 mpichler Exp $
//
//</file>


#include "sdfcam.h"

#include <ge3d/ge3d.h>

#include <iostream.h>



SDFCamera::SDFCamera (int obj_n, int par, const char* name)
: Object3D (obj_n, par, name), Camera ()
{
  dispstat_ = 0;  // set on reading
}


void SDFCamera::print ()
{
  cout << "Camera. ";

  Object3D::printobj ();  // name, number, channels

  Camera::print ();
}


void SDFCamera::computeParams ()
{
  if (pos_look_set_)  // position and lookat were set externally, channel values are ignored
    return;

  ge3d_push_new_matrix ((const float (*) [4]) trfmat_);

  ge3d_transform_mc_wc (0, 0, 0, &position_.x, &position_.y, &position_.z);
  ge3d_transform_mc_wc (0, 0, -1, &lookat_.x, &lookat_.y, &lookat_.z); 
  // ray from position to lookat determins line of sight

  ge3d_pop_matrix ();

} // computeParams
