#include <QvDB.h>
#include <QvInput.h>
#include <QvNode.h>
#include <QvState.h>
#include <QvGroup.h>
#include <iostream.h>
#include <fstream.h>

#include <QvDict.h>

// note: this test requires linkage of wrlsave.o
// and removing save stubs from QvNoop.C



main(int argc, char **argv)
{
    QvDB::init();

    QvInput	in;
    QvNode	*root;
    float version = 0.0;

    if (QvDB::read(&in, root) && root != NULL) {
	root->ref();
        version = in.getVersion ();
	printf("--- Read was ok\n");
    }
    else {
	root = NULL;
	printf("Read was bad\n");
    }

    ofstream fout("out.wrl");
    QvNode::saveAll (root, fout, version);

    if (root != NULL)
	root->unref();

    printf("--- VRML-tree saved in file out.wrl\n");

    return 0;
}
