// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
// 
//</copyright>


//<file>
//
// File:        fbrowser.h - interface to glyph browser as used in file chooser
//
// Created:      4 Jul 94   Michael Pichler
//
// Changed:      4 Jul 94   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_fbrowser_h
#define harmony_widgets_fbrowser_h

#include "libwidgets.h"

#include <IV-look/browser.h>
#include <hyperg/Dispatch/enter-scope.h>
class Adjustable;
class Cursor;
class IOHandler;
class TBScrollBox;
class WFileBrowserImpl;
class WidgetKit;
class Window;


class WFileBrowser: public Browser
{
  public:
    WFileBrowser(
      WidgetKit*,
      Action* accept,
      Action* cancel,
      Action* select = nil,
      boolean multiselect = false
    );
    virtual ~WFileBrowser();

    // Browser/InputHandler
    virtual void press(const Event&);
    virtual void drag(const Event&);
    virtual void release(const Event&);
    virtual void keystroke(const Event&);
    virtual InputHandler* focus_in();
    virtual void focus_out();

    virtual Adjustable* adjustable() const;

    virtual void refresh();

    virtual void append_item(
      Glyph*,
      Coord lborder = 3.0, Coord lstretch = 0.0, Coord lshrink = 0.0,
      Coord rborder = 15.0, Coord rstretch = fil, Coord rshrink = 0.0
    );
    virtual void remove_item(GlyphIndex);

    void scroll_to_first();
    void scroll_to_last();

  private:
    void open();  // choose selected item

    void select_previous();
    void select_next();
    void select_top();
    void select_bottom();
    void scroll_down();
    void scroll_up();
    void page_down();
    void page_up();
    void half_page_down();
    void half_page_up();
    void recenter();

    void rate_scroll_timer(long, long);

    WidgetKit* kit_;
    TBScrollBox* box_;  // body
    enum { selecting, grab_scrolling, rate_scrolling } mode_;
    Coord scale_;
    Cursor* save_cursor_;
    Window* save_window_;
    Coord start_scroll_pointer_;
    Coord cur_scroll_pointer_;
    Coord start_scroll_pos_;
    IOHandler* rate_handler_;
    long usec_rate_;
    Action* select_;
    boolean focus_;
};  // WFileBrowser

#endif
