// -*- C++ -*-
//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:    msgdlg.h
//
// Purpose: Interface of class MessageDialog
//
// Created: 1 Feb 1996 Bernhard Marschall (with lots of stuff from mpichler)
//
// $Id: msgdlg.h,v 1.7 1996/06/27 14:19:38 bmarsch Exp $
//
// Description:
//   
//</file>
//
// $Log: msgdlg.h,v $
// Revision 1.7  1996/06/27 14:19:38  bmarsch
// MessageDialog ref's/unref's itself when mapped/unmapped
//
// Revision 1.6  1996/03/20 16:50:53  bmarsch
// Remap positions window at previous position
//
// Revision 1.5  1996/03/20 13:27:51  bmarsch
// Added member window()
//
// Revision 1.4  1996/02/06 13:29:17  bmarsch
// Added member is_modified()
//
// Revision 1.3  1996/02/06 08:50:05  bmarsch
// Added members is_mapped() and run()
//
// Revision 1.2  1996/02/01 14:30:14  bmarsch
// Added optional caption line
//
// Revision 1.1  1996/02/01 13:24:43  bmarsch
// Initial revision
//
//

#ifndef hg_path_msgdlg_h
#define hg_path_msgdlg_h

#include <hyperg/hyperg/language.h>
#include <InterViews/coord.h>
#include <InterViews/resource.h>

class ApplicationWindow;
class Glyph;
class InputHandler;
class Style;
class TextBrowser;
class MsgTextBrowser;


//<class> 
//  
// Name:    MessageDialog
// 
// Purpose: Dialog with TextBrowser to show messages
// 
// Public Interface:
// - MessageDialog(const char* title, HgLanguage::Language language, const char* caption);
//   Constructor; needs window title, user interface language, and a caption.
//
// - virtual ~MessageDialog();
//   Destructor.
//
// - void map();
// - void unmap();
//   maps/unmaps dialog window.
//
// - boolean is_mapped();
//   Returns if dialog is mapped.
//
// - void run();
//   Map dialog and run it modal.
//
// - boolean is_modified() const;
//   Returns if dialog has been modified since the last unmap.
//
// - void setMessage(const char*, boolean scrollToBottom = false);
//   Set text in text browser. Lines are separated by newlines. By
//   setting the flag the browser scrolls to the end of the text.
//
// - void appendMessage(const char*, boolean scrollToBottom = false);
//   Append lines to the text browser. Lines are separated by
//   newlines. By setting the flag the browser scrolls to the end of
//   the text.
//
// - void clear();
//   Clear the browser.
//
// - TextBrowser* browser() const;
//   Returns the text browser.
//   
//
// Description:
//
//   MessageDialog is a simple dialog window consisting of a
//   TextBrowser to show some text and a close button to unmap the
//   dialog.
//
//</class> 

class MessageDialog : public Resource {
public:
  MessageDialog(
    const char* title = nil,
    HgLanguage::Language language = HgLanguage::Default,
    const char* caption = nil
  );
  MessageDialog(
    Style* style,
    const char* title = nil,
    HgLanguage::Language language = HgLanguage::Default,
    const char* caption = nil
  );
  virtual ~MessageDialog();

  void map();
  void unmap();
  boolean is_mapped() const;

  void run();

  boolean is_modified() const;

  void setMessage(const char*, boolean scrollToBottom = false);
  void appendMessage(const char*, boolean scrollToBottom = false);
  void clear();

  ApplicationWindow* window() const;
  TextBrowser* browser() const;

private:
  void init(
    Style* style,
    const char* title = nil,
    HgLanguage::Language language = HgLanguage::Default,
    const char* caption = nil
  );
  void build();

  HgLanguage::Language language_;
  Style* style_;
  ApplicationWindow* window_;
  boolean mapped_;
  boolean modified_;
  InputHandler* focus_;
  Glyph* caption_;
  MsgTextBrowser* text_;
  Coord left_, bottom_;   // save position
};

inline void MessageDialog::setMessage(const char* msg, boolean s) {
  clear();
  appendMessage(msg, s);
}

inline ApplicationWindow* MessageDialog::window() const {
  return window_;
}

inline boolean MessageDialog::is_mapped() const {
  return mapped_;
}

inline boolean MessageDialog::is_modified() const {
  return modified_;
}

#endif /* hg_path_msgdlg_h */
