#ifndef ORNAMENTEDOBJ_H
#define ORNAMENTEDOBJ_H

#include "linkablemapobj.h"

class OrnamentedObj:public LinkableMapObj {
public:	
    OrnamentedObj ();
    OrnamentedObj (QCanvas*);
    OrnamentedObj (OrnamentedObj*);
    ~OrnamentedObj ();
    virtual void init ();
    virtual void copy (OrnamentedObj*);

    virtual QString getHeading();			// returns the heading	
	virtual void setLinkColor();			// sets color according to colorhint, overloaded
	virtual void setColor(QColor);			// set the color of text and link
	QColor getColor ();						// get color of heading
    virtual void positionContents();
    virtual void move   (double,double);
    virtual void move   (QPoint);
    virtual void moveBy (double,double);
    virtual void moveBy (QPoint);
    virtual void move2RelPos (QPoint);		// move relativly to parent^
    virtual void move2RelPos (double,double);
    virtual void setNote(QString);			// set note
    virtual void setNote(NoteObj);			// set note
    virtual QString getNote();				// returns note	(HTML)
    virtual QString getNoteASCII();			// returns note	(ASCII)
    virtual QString getNoteOpenDoc();		// returns note	(OpenDoc)
    virtual void setURL (QString);
    virtual QString getURL ();
    virtual void setVymLink (QString);
    virtual QString getVymLink ();

	virtual void toggleStandardFlag(QString, bool);
	virtual void activateStandardFlag(QString);
	virtual bool isSetStandardFlag(QString);
	virtual QString getSystemFlagName (const QPoint &p);
	virtual bool isActiveFlag(const QString&);	// check if flag is set
	virtual void updateNoteFlag();
	virtual void setHideInExport(bool);		// set export of object (and childs)
	virtual bool hideInExport();
	virtual bool isHidden ();
	virtual QString getOrnAttr();			// get attributes for saveToDir

protected:
    HeadingObj *heading;			// Heading
	NoteObj note;					// Notes
	FlagRowObj *systemFlags;		// System Flags
	FlagRowObj *standardFlags;		// Standard Flags
	QRect ornamentsBBox;			// bbox of flags and heading
	QString url;					// url to external doc
	QString vymLink;				// path to another map
	bool hideExport;				// hide in exports if set
	bool hidden;					// true if temporary hidden
};

#endif
