#ifndef DECENTRALIZED_EVENTSET_SCHEDULING_MANAGER_H
#define DECENTRALIZED_EVENTSET_SCHEDULING_MANAGER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "SchedulingManager.h"

class TimeWarpSimulationManager;
class SimulationObject;
class TimeWarpEventSet;
class SchedulingData;

/** The SchedulingManager abstract base class.

    This is the abstract base class for all decentralized eventset
    scheduler implementations in the kernel. Different scheduler
    implementations must be derived from this abstract class.

*/
class DecentralizedEventSetSchedulingManager : public SchedulingManager {
public:
   /**@name Public Class Methods of SchedulingManager. */
   //@{
   
   /// Virtual Destructor.
   virtual ~DecentralizedEventSetSchedulingManager();

   /** Initialize the scheduler.
      
       This is a pure virtual function that has to be overriden.

       @param eventSet Set of events that constitute the input-queue.
       @param simObjArray Vector of simulation objects.
   */
   virtual void initialize(TimeWarpEventSet *eventSet,
                           vector<SimulationObject*>* simObjArray);
  
   /** Set the Scheduling Data.
      
       @param schedulingData handle to scheduling Data having head of eventsets.
   */
   void setSchedulingData(SchedulingData* schedulingData) {
     mySchedulingData = schedulingData;
   }

   //@} // End of Public Class Methods of SchedulingManager.
protected:
   /**@name Protected Class Methods of SchedulingManager. */
   //@{

   /// Default Constructor.
  DecentralizedEventSetSchedulingManager(TimeWarpSimulationManager* simMgr);

   /// Handle to my simulation manager.
   TimeWarpSimulationManager *mySimulationManager;
  
   /// Handle to the input queue.
   TimeWarpEventSet *myEventSet;
  
   /// The scheduler's list of objects.
   vector<SimulationObject*>* simulationObjectsArray;

   /// The class containing the head of eventsets
   SchedulingData* mySchedulingData;

   //@} // End of Protected Class Methods of SchedulingManager.
};

#endif //ifdef CENTRALIZED_EVENTSET_SCHEDULING_MANAGER_H
