#ifndef DEFAULT_COMMUNICATION_MANAGER_H
#define DEFAULT_COMMUNICATION_MANAGER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "SimulationManager.h"
#include "CommunicationManagerImplementationBase.h"

#include <vector>

/** The DefaultCommunicationManager class.

    This is the default communication manager implementation seen by
    the kernel. There are no optimizations built into this manager.
    This class is derived from the CommunicationManager abstract base
    class.

*/
class DefaultCommunicationManager :
   public CommunicationManagerImplementationBase {

public:

   /**@name Public Class Methods of DefaultCommunicationManager. */
   //@{
  
   /** Constructor.

       @param initPhysicalLayer Handle to the physical comm. layer.
       @param initSimulationManager Handle to the Simulation Manager.
   */
   DefaultCommunicationManager( PhysicalCommunicationLayer *initPhysicalLayer,
				TimeWarpSimulationManager *initSimulationManager );

   /// Destructor.
   ~DefaultCommunicationManager();

  virtual void configure( SimulationConfiguration & ){}
  
  //@} // End of Public Class Methods of DefaultCommunicationManager

};

#endif
