#ifndef DEFAULT_EVENT_H
#define DEFAULT_EVENT_H

// Copyright (c) 2003 Clifton Labs, Inc.  All rights reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com

#include "warped/Event.h"
#include "warped/EventId.h"

/** A default implementation of the Event interface. */

class DefaultEvent : public Event {
public:
  virtual ~DefaultEvent() = 0;
  
  inline const string &getSender() const { return sender; }

  inline const VTime &getSendTime() const { ASSERT( sendTime != 0 ); return *sendTime; }

  inline const string &getReceiver() const { return receiver; }
  inline void setReceiver( const string &newReceiver ){ receiver = newReceiver; }
  
  inline const VTime &getReceiveTime() const { ASSERT( receiveTime != 0 ); return *receiveTime; }

  inline const EventId &getEventId() const {
    return eventId;
  }

  //@} // End of Event Public Class Methods.

protected:
  /**
     Constructor to be called by applications directly.
  */
  inline DefaultEvent( const VTime &initSendTime,
		       const VTime &initRecvTime,
		       const string &initSender,
		       const string &initReceiver ) : sendTime( initSendTime.clone() ),
						      receiveTime( initRecvTime.clone() ),
						      sender( initSender ), 
						      receiver( initReceiver ){ }
  /**
     Constructor to be called by deserializers only.
  */
  inline DefaultEvent( const VTime &initSendTime,
		       const VTime &initRecvTime,
		       const string &initSender,
		       const string &initReceiver,
		       const unsigned int eventIdVal ) : sendTime( initSendTime.clone() ),
							 receiveTime( initRecvTime.clone() ),
							 sender( initSender ), 
							 receiver( initReceiver ),
							 eventId( eventIdVal ){}
  
private:
  /**@name Private Class Attributes of Event */
  //@{

  /// Time at which event was sent.
  const VTime *sendTime;

  /// Time at which event must be received and scheduled.
  const VTime *receiveTime;

  /// Id of the sender of the event.
  string sender;

  /// Id of the receiver of the event.
  string receiver;
  
  const EventId eventId;

  //@} // End of Event Private Class Methods.
};


#endif
