#ifndef IN_FILE_DATA_H
#define IN_FILE_DATA_H

// Copyright (c) The University of Cincinnati.
// All Rights Reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

using std::streampos;

/** The InFileData class

    This class represents a container class that stores the current
    position in a file that is being read. A time is associated with
    the current position so that a rollback can be accomplished.

*/
class InFileData {
public:

   /**@name Public Class Methods of InFileData. */
   //@{

   InFileData(const VTime& currentTime) : time(currentTime), pos(0){};
   InFileData(const VTime& currentTime, streampos currentPosition) :
      time(currentTime), pos(currentPosition){};
   
   ~InFileData(){};

   const VTime& getTime() const{
      return time;
   }

   streampos getPosition() const {
      return pos;
   }

   /// Overloaded operator <
   friend bool operator<(const InFileData& a, const InFileData& b){
      return a.time < b.time;
   }
  
   /// Overloaded operator ==
   friend bool operator==(const InFileData& a, const InFileData& b){
      return a.time == b.time;
   }
  
   /// Overloaded operator >
   friend bool operator>(const InFileData& a, const InFileData& b){
      return a.time > b.time;
   }
  
   /// Overloaded operator <<
   friend ostream& operator<<(ostream& os, const InFileData& a){
      return os << a.time;
   }

   //@} // End of Public Class Methods of InFileData.
   
protected:
   
   /**@name Protected Class Attributes of InFileData. */
   //@{
   
   /// needed to sort the entries in the FileQueue
   const VTime& time;

   /// position of last read in a file
   streampos pos; 

   //@} // End of Protected Class Attributes of InFileData.
};
#endif
