// Copyright (c) The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
//
// $Id: SequentialConfigurationManager.cpp
//
//---------------------------------------------------------------------------

#include "SequentialConfigurationManager.h"

SequentialConfigurationManager::SequentialConfigurationManager( Application *initApplication )
  : mySimulationManager( new SequentialSimulationManager( initApplication ) ),
    myEventSetFactory(new EventSetFactory()){}

SequentialConfigurationManager::~SequentialConfigurationManager(){
  delete myEventSetFactory;
}

void
SequentialConfigurationManager::configure( SimulationConfiguration &configuration ){
  mySimulationManager->configure( configuration );
}

SimulationManager *
SequentialConfigurationManager::getSimulationManager(){
  return mySimulationManager;
}
