#include "warped/SequentialFileManager.h"
#include <iostream>

using std::cin;
using std::cout;
using std::cerr;

namespace warped {

SequentialFileManager::SequentialFileManager(){}

SequentialFileManager::~SequentialFileManager(){
  vector<fstream *> *_files = files.getElementVector();
  for( vector<fstream *>::iterator i = _files->begin();
       i < _files->end();
       i++ ){
    if( (*i) ){
      (*i)->close();
    }
  }
  delete _files;
}

fstream &
SequentialFileManager::open( const string &fileName,
			     ios::openmode mode ){
  fstream *retval = 0;
  retval = files.find( fileName );
  if( retval == 0 ){
    retval = new fstream( fileName.c_str(), mode );
    if( fileName == "stdout" ){
      dynamic_cast<ios *>(retval)->rdbuf(cout.rdbuf());
    }
    else if ( fileName == "stderr" ){
      dynamic_cast<ios *>(retval)->rdbuf(cerr.rdbuf());
    }
    else if ( fileName == "stdin" ){
      dynamic_cast<ios *>(retval)->rdbuf(cin.rdbuf());
    }
    files.insert( fileName, retval );
  }
  return *retval;
}

}
