#ifndef SEQUENTIAL_FILE_MANAGER_H
#define SEQUENTIAL_FILE_MANAGER_H

// Copyright (c) 2004 Clifton Labs, Inc.
// All Rights Reserved.

// CLIFTON LABS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
// SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  CLIFTON LABS SHALL NOT BE
// LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT
// OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Dale E. Martin              dmartin@cliftonlabs.com

#include <clutils/StringHashMap.h>
#include "warped/FileManager.h"

namespace warped{

class SequentialFileManager : public FileManager {
  friend class FileManager;
public:
  fstream &open( const string &fileName, ios::openmode mode );

protected:
  SequentialFileManager();
  ~SequentialFileManager();

private:
  StringHashMap<fstream *> files;
};

}
#endif
