#ifndef EVENT_TEST_H
#define EVENT_TEST_H

#include "warped/DefaultEvent.h"
#include "SerializableTest.h"
#include "warped/SerializedInstance.h"
#include "warped/IntVTime.h"

class EventTest : public SerializableTest {
  class EventTestTestEvent : public DefaultEvent {
  public:
    const string &getDefaultSender(){
      static string defaultSender = "DefaultSender";
      return defaultSender;
    }
    const string &getDefaultReceiver(){
      static string defaultReceiver = "DefaultReceiver";
      return defaultReceiver;
    }
    
    static const string &getEventTestTestEventType(){
      static string testEventType = "EventTestTestEvent";
      return testEventType;
    }
    
    const string &getDataType() const { return getEventTestTestEventType(); }
    
    bool eventCompare( const Event *other ){
      return Event::compareEvents( this, other );
    }
    
    EventTestTestEvent() : DefaultEvent( IntVTime::getIntVTimeZero(),
					 IntVTime::getIntVTimePositiveInfinity(),
					 getDefaultSender(),
					 getDefaultReceiver() ){}

    

    static Serializable *deserialize( SerializedInstance *instance ){
      Serializable *retval = 0;

      const VTime *sendTime = dynamic_cast<VTime *>(instance->getSerializable());
      const VTime *recvTime = dynamic_cast<VTime *>(instance->getSerializable());
      const string &sender = instance->getString();
      const string &receiver = instance->getString();
      const unsigned int eventId = instance->getUnsigned();

      retval = new EventTestTestEvent( *sendTime, 
				       *recvTime, 
				       sender, 
				       receiver, 
				       eventId, 
				       "" );

      return retval;
    }
  private:
    EventTestTestEvent( const VTime &sendTime,
			const VTime &recvTime,
			const string &sender,
			const string &receiver,
			const unsigned int eventId,
			const string &myString ) : 
      DefaultEvent( sendTime, recvTime, sender, receiver, eventId ),
      privateString(myString){}    
    
    const string privateString;
};


  CPPUNIT_TEST_SUITE( EventTest );
  CPPUNIT_TEST( testSerialization );
  CPPUNIT_TEST( testEventIds );
  CPPUNIT_TEST_SUITE_END();

public:
  // Test interface
  void setUp();
  void tearDown();

  void testConstructor();
  void testSerialization();
  void testEventIds();
  void testSerialization( const Event *toTest, const string &dataType );

};

#endif
