// Adds a cookie
function webdeveloper_addCookie()
{
    window.openDialog("chrome://webdeveloper/content/dialogs/add_cookie.xul", "webdeveloper-add-cookie-dialog", "centerscreen,chrome,modal");
}

// Clears all session cookies
function webdeveloper_clearSessionCookies()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the clearing is confirmed
    if(webdeveloper_clearConfirmation(stringBundle.getString("webdeveloper_clearSessionCookiesConfirmation")))
    {
        var cookie        = null;
        var cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
        var cookies       = cookieManager.enumerator;
        var removed       = 0;

        // Loop through the cookies
        while(cookies.hasMoreElements())
        {
            cookie = cookies.getNext();

            // If this is a cookie with no expiration
            if(cookie instanceof Components.interfaces.nsICookie && cookie.expires == "0")
            {
                cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
                removed++;
            }
        }

        // If the hide informational dialogs preference is not set
        if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
        {
            var title = stringBundle.getString("webdeveloper_clearSessionCookies");

            // If one session cookie was removed
            if(removed == 1)
            {
                webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_clearSessionCookiesSingleResult"));
            }
            else
            {
                webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_clearSessionCookiesMultipleResult", [removed]));
            }
        }
    }
}

// Deletes all the cookies for the current domain
function webdeveloper_deleteDomainCookies()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the deletion is confirmed
    if(webdeveloper_deleteConfirmation(stringBundle.getString("webdeveloper_deleteDomainCookiesConfirmation")))
    {
        var cookie         = null;
        var cookieManager  = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
        var cookies        = new Array();
        var cookiesLength  = null;
        var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength = documentList.length;
        var pageDocument   = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument = documentList[i];
            cookies      = cookies.concat(webdeveloper_getCookies(pageDocument.location.hostname, "/", false));
        }

        cookiesLength = cookies.length;

        // Loop through all the cookies
        for(i = 0 ; i < cookiesLength; i++)
        {
            cookie = cookies[i];

            cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
        }

        // If the hide informational dialogs preference is not set
        if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
        {
            var title = stringBundle.getString("webdeveloper_deleteDomainCookies");

            // If one cookie was found
            if(cookiesLength == 1)
            {
                webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_deleteDomainCookiesSingleResult"));
            }
            else
            {
                webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_deleteDomainCookiesMultipleResult", [cookiesLength]));
            }
        }
    }
}

// Deletes all the cookies for the current path
function webdeveloper_deletePathCookies()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the deletion is confirmed
    if(webdeveloper_deleteConfirmation(stringBundle.getString("webdeveloper_deletePathCookiesConfirmation")))
    {
        var cookie         = null;
        var cookieManager  = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
        var cookies        = new Array();
        var cookiesLength  = null;
        var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength = documentList.length;
        var pageDocument   = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument = documentList[i];
            cookies      = cookies.concat(webdeveloper_getCookies(pageDocument.location.hostname, pageDocument.location.pathname, false));
        }

        cookiesLength = cookies.length;

        // Loop through all the cookies
        for(i = 0 ; i < cookiesLength; i++)
        {
            cookie = cookies[i];

            cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
        }

        // If the hide informational dialogs preference is not set
        if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
        {
            var title = stringBundle.getString("webdeveloper_deletePathCookies");

            // If one cookie was found
            if(cookiesLength == 1)
            {
                webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_deletePathCookiesSingleResult"));
            }
            else
            {
                webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_deletePathCookiesMultipleResult", [cookiesLength]));
            }
        }
    }
}

// Toggles cookies
function webdeveloper_toggleCookies(element)
{
    var cookieBehavior = 0;

    // If disabling cookies
    if(element.getAttribute("checked"))
    {
        cookieBehavior = 2;
    }

    webdeveloper_setIntegerPreference("network.cookie.cookieBehavior", cookieBehavior);
}

// Toggles external site cookies
function webdeveloper_toggleExternalSiteCookies(element)
{
    var cookieBehavior = 0;

    // If disabling external cookies
    if(element.getAttribute("checked"))
    {
        cookieBehavior = 1;
    }

    webdeveloper_setIntegerPreference("network.cookie.cookieBehavior", cookieBehavior);
}

// Updates the disable cookies menu
function webdeveloper_updateDisableCookiesMenu(suffix)
{
    var disableExternalSiteCookiesChecked = false;
    var disableExternalSiteCookiesMenu    = document.getElementById("webdeveloper-disable-external-site-cookies-" + suffix);
    var disableCookiesChecked             = false;
    var disableCookiesPreferenceValue     = webdeveloper_getIntegerPreference("network.cookie.cookieBehavior", true);

    // If the cookie preference value is set to 2
    if(disableCookiesPreferenceValue == 2)
    {
        disableCookiesChecked = true;
    }
    else if(disableCookiesPreferenceValue == 1)
    {
        disableExternalSiteCookiesChecked = true;
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-all-cookies-" + suffix), "checked", disableCookiesChecked);
    webdeveloper_configureElement(disableExternalSiteCookiesMenu, "checked", disableExternalSiteCookiesChecked);
    webdeveloper_configureElement(disableExternalSiteCookiesMenu, "disabled", disableCookiesChecked);
}

// Displays all the cookies for the page
function webdeveloper_viewCookieInformation()
{
    var cellDataElement   = null;
    var cellHeaderElement = null;
    var cookie            = null;
    var cookieExpires     = null;
    var cookieHost        = null;
    var cookieLength      = null;
    var cookieSecure      = null;
    var cookies           = null;
    var date              = null;
    var dateService       = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].getService(Components.interfaces.nsIScriptableDateFormat);
    var documentList      = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength    = documentList.length;
    var linkElement       = null;
    var location          = null;
    var oldTab            = getBrowser().selectedTab;
    var oldURL            = getBrowser().currentURI.spec;
    var generatedDocument = webdeveloper_generateDocument("");
    var headerElement     = generatedDocument.createElement("h1");
    var pageDocument      = null;
    var pElement          = null;
    var preElement        = null;
    var stringBundle      = document.getElementById("webdeveloper-string-bundle");
    var tableElement      = null;
    var tableRowElement   = null;
    var title             = stringBundle.getFormattedString("webdeveloper_viewCookieInformationTitle", [oldURL]);

    generatedDocument.title = title;

    webdeveloper_addGeneratedStyles(generatedDocument);

    headerElement.appendChild(generatedDocument.createTextNode(title));
    generatedDocument.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        headerElement = generatedDocument.createElement("h2");
        pageDocument  = documentList[i];
        linkElement   = generatedDocument.createElement("a");
        location      = pageDocument.location;
        cookies       = webdeveloper_getCookies(location.hostname, location.pathname, true);
        cookieLength  = cookies.length;

        linkElement.setAttribute("href", pageDocument.documentURI);
        linkElement.appendChild(generatedDocument.createTextNode(pageDocument.documentURI));
        headerElement.appendChild(linkElement);
        generatedDocument.body.appendChild(headerElement);

        // If there are no cookies
        if(cookieLength == 0)
        {
            pElement = generatedDocument.createElement("p");

            pElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_noCookies")));
            generatedDocument.body.appendChild(pElement);
        }
        else
        {
            // Loop through the cookies
            for(var j = 0; j < cookieLength; j++)
            {
                cookie       = cookies[j];
                cookieHost   = cookie.host;
                cookieSecure = cookie.isSecure;
                tableElement = generatedDocument.createElement("table");

                //  Cookie name
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_name")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedDocument.createTextNode(cookie.name));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Cookie value
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_value")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.setAttribute("class", "shaded");
                cellDataElement.appendChild(generatedDocument.createTextNode(cookie.value));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // If the cookie host starts with '.'
                if(cookieHost.charAt(0) == ".")
                {
                    cookieHost = cookieHost.substring(1);
                }

                //  Cookie host
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_host")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedDocument.createTextNode(cookieHost));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Cookie path
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_path")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.setAttribute("class", "shaded");
                cellDataElement.appendChild(generatedDocument.createTextNode(cookie.path));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Cookie secure
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_secure")));
                tableRowElement.appendChild(cellHeaderElement);

                // If the cookie is secure
                if(cookieSecure)
                {
                    cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_yes")));
                }
                else
                {
                    cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_no")));
                }

                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // If the cookie has an expiration date
                if(cookie.expires)
                {
                    date          = new Date(cookie.expires * 1000);
                    cookieExpires = dateService.FormatDateTime("", dateService.dateFormatLong, dateService.timeFormatSeconds, date.getFullYear(), date.getMonth()+1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
                }
                else
                {
                    cookieExpires = stringBundle.getString("webdeveloper_viewCookieInformationSession");
                }

                //  Cookie expires
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_expires")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.setAttribute("class", "shaded");
                cellDataElement.appendChild(generatedDocument.createTextNode(cookieExpires));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                generatedDocument.body.appendChild(tableElement);

                pElement = generatedDocument.createElement("p");

                generatedDocument.body.appendChild(pElement);
            }
        }
    }

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}
