// Toggles the cache
function webdeveloper_toggleCache(element)
{
    webdeveloper_disablePreference(element, "browser.cache.disk.enable");
    webdeveloper_disablePreference(element, "browser.cache.memory.enable");
}

// Toggles Java
function webdeveloper_toggleJava(element)
{
    webdeveloper_disablePreference(element, "security.enable_java");
}

// Toggles meta redirects
function webdeveloper_toggleMetaRedirects(element)
{
    webdeveloper_enablePreference(element, "webdeveloper.meta.redirects.disable");
    webdeveloper_updateMetaRedirects();
}

// Toggles the minimum font size
function webdeveloper_toggleMinimumFontSize(element)
{
    var defaultFontSize = 10;
    var minimumFontSize = null;

    // If disabling the minimum font size
    if(element.getAttribute("checked"))
    {
        minimumFontSize = webdeveloper_getIntegerPreference("font.minimum-size.x-western", true);

        // If the minimum font size is not set
        if(minimumFontSize == 0)
        {
            minimumFontSize = defaultFontSize;
        }

        webdeveloper_deletePreference("font.minimum-size.x-western");
        webdeveloper_setIntegerPreference("webdeveloper.font.minimum.size", minimumFontSize);
    }
    else
    {
        minimumFontSize = webdeveloper_getIntegerPreference("webdeveloper.font.minimum.size", true);

        // If the minimum font size is not set
        if(minimumFontSize == 0)
        {
            minimumFontSize = defaultFontSize;
        }

        webdeveloper_deletePreference("webdeveloper.font.minimum.size");
        webdeveloper_setIntegerPreference("font.minimum-size.x-western", minimumFontSize);
    }

    BrowserReloadSkipCache();
}

// Toggles the page colors
function webdeveloper_togglePageColors(element)
{
    webdeveloper_disablePreference(element, "browser.display.use_document_colors");
    BrowserReloadSkipCache();
}

// Toggles referrers
function webdeveloper_toggleReferrers(element)
{
    var sendReferrer = 2;

    // If disabling referrers
    if(element.getAttribute("checked"))
    {
        sendReferrer = 0;
    }

    webdeveloper_setIntegerPreference("network.http.sendRefererHeader", sendReferrer);
}

// Updates the disable menu
function webdeveloper_updateDisableMenu(suffix)
{
    var checked = !webdeveloper_getBooleanPreference("browser.cache.disk.enable", false) && !webdeveloper_getBooleanPreference("browser.cache.memory.enable", false);

    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-cache-" + suffix), "checked", checked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-java-" + suffix), "checked", !webdeveloper_getBooleanPreference("security.enable_java", false));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-javascript-" + suffix), "checked", !webdeveloper_getBooleanPreference("javascript.enabled", false));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-meta-redirects-" + suffix), "checked", webdeveloper_getBooleanPreference("webdeveloper.meta.redirects.disable", true));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-minimum-font-size-" + suffix), "checked", webdeveloper_getIntegerPreference("font.minimum-size.x-western", true) == 0);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-page-colors-" + suffix), "checked", !webdeveloper_getBooleanPreference("browser.display.use_document_colors", false));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-popup-blocker-" + suffix), "checked", !webdeveloper_getBooleanPreference("dom.disable_open_during_load", false));

    // If the referrer preference is set to 0
    if(webdeveloper_getIntegerPreference("network.http.sendRefererHeader", false) == 0)
    {
        checked = true;
    }
    else
    {
        checked = false;
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-referrers-" + suffix), "checked", checked);
}
