#
#--
#
# $Id: textile.rb 369 2005-12-24 11:37:40Z thomas $
#
# webgen: template based static website generator
# Copyright (C) 2004 Thomas Leitner
#
# This program is free software; you can redistribute it and/or modify it under the terms of the GNU
# General Public License as published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with this program; if not,
# write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
#++
#

begin
  require 'redcloth'
  require 'webgen/plugins/contenthandlers/default'

  module ContentHandlers

    # Handles content in Textile format using RedCloth.
    class TextileContentHandler < DefaultContentHandler

      summary "Handles content in Textile format using RedCloth"

      register_format( 'textile' )

      def format_content( txt )
        RedCloth.new( txt ).to_html
      rescue Exception => e
        self.logger.error { "Error converting Textile text to HTML: #{e.message}" }
        ''
      end

    end

  end

rescue LoadError => e
  self.logger.warn { "Textile not available as content format as RedCloth could not be loaded: #{e.message}" }
end
