# -*- makefile -*-

# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1


# These are used for cross-compiling and for saving the configure script
# from having to guess our platform (since we know it already)
DEB_HOST_GNU_TYPE   ?= $(shell dpkg-architecture -qDEB_HOST_GNU_TYPE)
DEB_BUILD_GNU_TYPE  ?= $(shell dpkg-architecture -qDEB_BUILD_GNU_TYPE)


CFLAGS = -Wall -g

ifneq (,$(findstring noopt,$(DEB_BUILD_OPTIONS)))
	CFLAGS += -O0
else
	CFLAGS += -O2
endif

apply-patches:
	dh_testdir
	-quilt push -a
	touch apply-patches

unapply-patches:
	dh_testdir
	-quilt pop -a
	-rm -rf .pc
	-rm apply-patches

build: build-stamp

build-stamp: apply-patches
	dh_testdir
	make toolchain
	./configure --enable_debug --prefix=/usr # not GNU autoconf configure!

	# Add here commands to compile the package.
	cd site; klone -c import ../userdata
	$(MAKE) KLONE=/usr/bin/klone

	touch build-stamp

clean: unapply-patches
	dh_testdir
	dh_testroot
	rm -f build-stamp 

	# Add here commands to clean up after the build process.
	-$(MAKE) clean
	find . -name "*.o" -exec rm '{}' \;
	find . -name "*.a" -exec rm '{}' \;
	find . -wholename "*/.depend" -exec rm '{}' \;
	-rm klone_conf.h libu/{Makefile.conf,party.log,libu_conf.h}
	-rm makl/etc/toolchain.* Makefile.conf build/libu/party.log

	dh_clean 

install:: build
	dh_testdir
	dh_testroot
	dh_clean -k 
	dh_installdirs


# Build architecture-independent files here.
binary-indep: build install
# We have nothing to do by default.

# Build architecture-dependent files here.
binary-arch: build install
	dh_testdir
	dh_testroot
	dh_installchangelogs 
	dh_installdocs
	dh_installinit
	dh_install
	dh_link
	dh_strip
	dh_compress
	dh_fixperms
	dh_installdeb
	dh_shlibdeps
	dh_gencontrol
	dh_md5sums
	dh_builddeb

binary: binary-indep binary-arch
.PHONY: build clean binary-indep binary-arch binary install unapply-patches
