/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iomanip>

#include <stdio.h> /* for snprintf */
#include <pwd.h>

#include "wflistener.h"
#include "defs.h"


wf_listener::wf_listener(int protocol, int port, const wf_ipaddr& ipaddr,
			 const string& prog, int uid, int pid) :
  wf_service(protocol, port, ipaddr),
  _prog(prog),
  _uid(uid),
  _pid(pid)
{}

ostream&
wf_listener::print(ostream& os) const {
  struct passwd* pw;
  char str[40];

  snprintf(str, sizeof(str) - 1, "%-40s", tostr().c_str());
  os << str;

  os << setw(10);
  if ((pw = getpwuid(_uid)) != NULL)
    os << pw->pw_name;
  else
    os << _uid;

  return os << "   " << setw(6) << _pid << " " << _prog << endl;
}
