/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>

#include "wfmetahost.h"
#include "wfindent.h"
#include "defs.h"


wf_metahost_elem::wf_metahost_elem() :
  host_base(NULL)
{}

wf_metahost_elem::~wf_metahost_elem() {
  if (host_base != NULL)
    delete host_base;
}

wf_metahost_elem::wf_metahost_elem(const wf_metahost_elem& metahost_elem) {
  if (metahost_elem.host_base != NULL)
    host_base = metahost_elem.host_base->VClone();
  else
    host_base = NULL;
}

wf_metahost_elem&
wf_metahost_elem::operator=(const wf_metahost_elem& metahost_elem) {
  if (this != &metahost_elem)
    host_base = metahost_elem.host_base->VClone();
  return *this;
}

wf_metahost_elem::wf_metahost_elem(const wf_metahost& metahost) {
  set(metahost);
}

wf_metahost_elem::wf_metahost_elem(const wf_ipaddr& ipaddr) {
  set(ipaddr);
}

wf_metahost_elem::wf_metahost_elem(const wf_network& network) {
  set(network);
}

wf_metahost_elem::wf_metahost_elem(const wf_ipaddr_range& ipaddr_range) {
  set(ipaddr_range);
}


bool
wf_metahost_elem::set(const wf_metahost& metahost) {
  host_base = new wf_metahost(metahost);
  return true;
}

bool
wf_metahost_elem::set(const wf_ipaddr& ipaddr) {
  host_base = new wf_ipaddr(ipaddr);
  return true;
}

bool
wf_metahost_elem::set(const wf_network& network) {
  host_base = new wf_network(network);
  return true;
}

bool
wf_metahost_elem::set(const wf_ipaddr_range& ipaddr_range) {
  host_base = new wf_ipaddr_range(ipaddr_range);
  return true;
}


ostream&
wf_metahost_elem::print(ostream& os) const {
  if (host_base != NULL)
    os << host_base;
  else
    os << "(NULL)"; // RV@@6
  return os;
}

ostream&
wf_metahost_elem::output_xml(ostream& os, unsigned int indent_level) const {
  if (host_base != NULL)
    host_base->output_xml(os, indent_level);
  return os;
}

ostream&
wf_metahost_elem::debugprint(ostream& os) const {
  return os << _("Metahost elem:\t") << *this << endl;
}


ostream&
operator<<(ostream& os, const wf_metahost_elem& elem) {
  return elem.print(os);
}

bool
operator==(const wf_metahost_elem& elem1, const wf_metahost_elem& elem2) {
  return (elem1.host_base == elem2.host_base);
}
