/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_LISTENER_H
#define _WF_LISTENER_H

#include <iostream>
#include <string>

#include "wfservice.h"

/**
 * listener: it's an extension of the service notion.
 * It stores information about the process holding the listening port
 * (uid, pid, name).
 */
class wf_listener : public wf_service {
 public:
  wf_listener(int protocol, int port, const wf_ipaddr& ipaddr,
	      const string& prog, int uid, int pid);
  virtual ~wf_listener() {}
  // wf_listener(const wf_listener& listener) {} implicit copy constructor
  virtual wf_listener* VClone() const;

  ostream& print(ostream& os) const;
  
 private:
  string _prog;
  int _uid;
  int _pid;
};

inline wf_listener*
wf_listener::VClone() const {
  return new wf_listener(*this);
}

#endif
