/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 2002 Malcolm Walker
  Based on code copyright  (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "application.h"
#include "multilineedit.h"
#include "pushbutton.h"
#include "togglebutton.h"
#include "slider.h"
#include "mixer.h"
#include "sample.h"
#include "music.h"
#include "painter.h"
#include "debug.h"
#include "rootwindow.h"
#include "box.h"

#include <iostream>
#include <cmath>

#include <sigc++/object_slot.h>

using namespace wftk;

/* MediaPlayer.
 
	plays all sort of music files: midi, mods, wavs, mp3
		
*/

//size of waveform display
//#define H 75
//#define W 200
#define N 100

//reload value (in miliseconds) for myTimer
//this results in the waveform display updated 10 times per second
#define REFRESH_TIME 100

class MeterWidget : public Widget
{
 public:
  MeterWidget() : refresh(REFRESH_TIME)
  {
    refresh.alarm.connect(SigC::slot(*this, &MeterWidget::timerSlot));
    Mixer::instance()->data.connect(slot(*this, &MeterWidget::grafx));
    Mixer::instance()->enableHook(true);
  }
  virtual ~MeterWidget() {}

 protected:
  virtual void draw(Surface&, const Point&, const Region&);
  virtual void setPackingInfo()
  {
    Widget::setPackingInfo();

    packing_info_.x.pref = 200;
    packing_info_.y.pref = 75;
  }

 private:
  Timer refresh;
  void timerSlot() {invalidate();}

  Point pointsL[N];
  Point pointsR[N];
  void grafx(Uint8*, int);
};

class Mp3 : public Application
{
  Slider *slider2;
  Music *music;

public:

  void sliderVal(int val)
  {
    
    slider2->setColor(Color(val,64+val, val));
    Mixer::instance()->setMusicVolume(val);
  }

  Mp3(int argc, char** argv) : 
    Application(argc, argv), music(0)
    {
      std::cout << "starting up ..." << std::endl;
      //do you init here

      //hey this is just a demo...
      //yepp, I could have added a nice file dialog ...
      //take it as an exercise to code one yourself :P
      int argnum = (argc > 1 && strcmp(argv[1], "--") == 0) ? 2 : 1;
      std::string mp3name;
      if(argnum < argc)
        mp3name = argv[argnum];
      else
        {
          std::cout << "filename :";
          std::cin >> mp3name;
        }

      //a simple gui just for fun... actually no more mp3 playing stuff in
      //here
#ifdef _WIN32
      new RootWindow(640,480);
#else
      //smaller window with native pixeldepth for X
      new RootWindow(640,130);
#endif

      RootWindow::instance()->setTitle("libwftk music player");

      //eg fontloading ....
      //(these fonts are used by several gui elements,
      // so you should slways load text_font and button_font when
      // using widgets from libwftk.
      Font::registry.load("text_font","wf_opal.ttf, 18, 0x80FF80, 0x101010");
      Font::registry.load("button_font","wf_opal.ttf, 18, 0x80FF80, 0x101010");

      //register this wav file as resources "press"
      //which is played whenever an button gets pressed
      Sample::registry.load("press","press.wav");
      //same but for "release"
      Sample::registry.load("release","release.wav");

      //register song to play
      Music::registry.load("song",mp3name.c_str());

      //create your gui here

      Box *vbox = new Box(Box::TOP_TO_BOTTOM);
      RootWindow::instance()->pack(vbox);

      vbox->packBack(new MultiLineEdit("... originally written by Karsten Laux using the libuta toolkit"));

      Box *hbox = new Box(Box::LEFT_TO_RIGHT);
      vbox->packBack(hbox);

      hbox->packBack(new MeterWidget());

      //a pushbutton
//       PushButton* quit_button 
// 	= new PushButton(back, back->width()-100,40, 90, 30);
//       quit_button->setText("Quit");
//       quit_button->setColor(Color(32,32,128));

      Box *vbox2 = new Box(Box::TOP_TO_BOTTOM);
      hbox->packBack(vbox2);

      Box *hbox2 = new Box(Box::LEFT_TO_RIGHT);
      vbox2->packBack(hbox2);

      PushButton* but;

      ToggleButton *pause_but = new ToggleButton("Pause");
      pause_but->pressed.connect(slot(*Mixer::instance(), &Mixer::pauseMusic));
      pause_but->released.connect(slot(*Mixer::instance(), &Mixer::resumeMusic));


      but = new PushButton("Rewind");
      but->clicked.connect(slot(*Mixer::instance(), &Mixer::rewindMusic));
      hbox2->packBack(but);
      but = new PushButton("Play");
      but->clicked.connect(slot(*Mixer::instance(), &Mixer::startMusic));
      but->clicked.connect(slot(*pause_but, &ToggleButton::release));
      hbox2->packBack(but);

      hbox2->packBack(pause_but);

      but = new PushButton("Stop");
      but->clicked.connect(slot(*Mixer::instance(), &Mixer::stopMusic));
      hbox2->packBack(but);

      slider2 = new Slider(Slider::HORIZONTAL, 15);
      slider2->setColor(Color(50,200,100,128));
      slider2->setButtonColor("lightgrey");
      slider2->setRange(0,128);

      slider2->valueChanged.connect(slot(*this, &Mp3::sliderVal));
      slider2->setValue(64);

      vbox2->packFront(slider2);

      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
  //     quit_button->clicked.connect(quitSlot());
      
      //mixer() maybe NULL if we have no access to the audio device      
      Mixer::instance()->enableHook(true);

      //HERE is the mp3 player part:
      //----------------------------
      //(BTW, it will also load streamed wavs, midis and mods..)
 //      music = new Music(mp3name.c_str());
//       music->play();

      Mixer::instance()->setMusic("song");
    }

  virtual ~Mp3()
    {
      std::cout << "shutting down ..." << std::endl;
      //do your cleaning up here

      delete music;
    }
};

void MeterWidget::draw(Surface& surf, const Point& offset, const Region& r)
{
  surf.fill(r, "darkgrey");

  // FIXME make this respect region masking

  Painter painter(&surf);
  
  painter.setColor("green");
  for(int n = 1; n < N; n++)
    {
      painter.line(pointsL[n-1] + offset, pointsL[n] + offset);
    }
  
  painter.setColor("red");
   for(int n = 1; n < N; n++)
    {
      painter.line(pointsR[n-1] + offset, pointsR[n] + offset);
    }
}

void MeterWidget::grafx(Uint8* data, int len)
{
  
  //sample the data ...
  int skip = len / 4 / N;
  Sint16 *ptr = (Sint16*)data;
  for(int n = 0; n < N ; n++)
    {
      pointsL[n] = Point(n*width()/N,height()/2 + (*ptr)/1000);
      pointsR[n] = Point(n*width()/N, height()/2 + (*(ptr+1)) /1000);
        
      ptr += skip;
    }
}

     
int main (int argc, char **argv)
{
  Debug::init(Debug::GENERIC);

  return Mp3(argc, argv).exec();
}

