/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _PROGRESSDIALOG_H
#define _PROGRESSDIALOG_H

#include <wftk/bordereddialog.h>
#include <wftk/label.h>

namespace wftk {

/** 
 * Simple widget that paints a progress meter
 */
class ProgressBar : public Widget
{
 public:
  /**
   * Create a progress bar
   *
   * when starting, it's at 0%. Makes sense, right?
   */
  ProgressBar() : percentage_(0) {}
  /**
   * set the percent value of the progress bar
   *
   * checks the value to make sure it's not bigger than 100 (we don't want to
   * look silly like openoffice install, right?)
   */
  void setValue(Uint8 data);
 protected:
  ///
  virtual void handleResize(Uint16 w, Uint16 h);
  ///
  virtual void setPackingInfo();
 private:
  ///
  Uint8 percentage_;
};

/**
 * progress meter dialog
 */
class ProgressDialog : public BorderedDialog
{
 //OBJECT

 public:
  /**
   * Create a window with a progress bar
   *\param label the label of the progress bar
   *\param border_res_name std::string containing the name of the ressource
   *                       to use for the frame. The ressources are 
   *                       \li &lt;name&gt;_v for the vertical frames
   *                       \li &lt;name&gt;_h for the horizontal frames
   *                       \li &lt;name&gt;_edge for the corners
   *
   *                       If any of those ressources aren't found, it is left 
   *                       out. Defaults to "progressdialog_frame"
   *\param font font to use for the label, defaults to Font()
   *
   * Create a non-modal dialog window with a progress bar. Uses the
   * following resources to represent the bar and window:
   *   \li progressdialog_bar_surface for the bar
   *   \li progressdialog_surface     for the window
   */
  explicit ProgressDialog(const std::string& label = "", 
		   const std::string& border_res_name="progressdialog_frame",
			  const Font& font=Font());
  /**
   * set the value of the progress bar, calls ProgressBar::setValue()
   *\param percentage the percentage of process to set the bar to
   */
  void setValue(Uint8 percentage) {bar_->setValue(percentage);}

 protected:
  ///
  virtual void setPackingInfo();

 private:
  ///
  ProgressBar *bar_;

};

#if 0 // this is evil we don't do that anymore

#define CREATE_PROGRESSBAR(info_txt) \
wftk::ProgressDialog progress; \
progress.info(info_txt); \
progress.exec();
#define UPDATE_PROGRESSBAR(percent) progress.setValue(percent);
#define REMOVE_PROGRESSBAR progress.close();

#endif

}

#endif // !_DIALOG
