// This module implements the parser for the programs given in the [program]
// section of the configurtion file. Currently only one instance of this class
// may exist.

class ParseProgram {
  protected:
  // The indexing mode we are using:
  card_id_type cit;

  public:
  static ParseProgram* instance; // Current instance of class or 0
                                 // The user should not modify this variabel

  // The possible types for symbols:
  enum types { tINT32,tINT64,tBOOL,tMAC,tIP,tUNKNOWN };
  
  ParseProgram();
  ~ParseProgram();
  
  // To set the program to execute call this funtion.
  // linebase should be set to linenumber of the first line in the program
  // prg should contain the program itself.
  // The function returns an error message or 0.
  // The getSymbol function is called for all encounterd symbols.
  char* setProgram(int linebase, char* prg);  

  // This is called by setProgram. Can be used by the user to insert own
  // variabels. If the user wants to insert a variabel location should be set
  // to it's location and the function should return the type of the variabel.
  // The function should return tUNKNOWN on an unknown variabel.
  // If INT32 is returned the variabel will be treated as an expression 
  // (rvalue) and not a variabel (lvalue). That is because integer variabels 
  // has 64 bits.
  virtual types getSymbol(char* name, void*& location) { return tUNKNOWN; }
  
  // If setProgram returned successfully this can be called as many times
  // as wanted to execute the program. Returns an error message on
  // runtime error:
  char* execProgram();
  
  // This can be called to assert that we are using a specific indexing
  // mode. Returns an error message another indexing mode is used.
  char* assert_cit(card_id_type);
  
  // The following are called by execProgram and is used to access the
  // table.
  //
  // They can set the error parameter to an error message but should return
  // meaningfull values in all cases.  
  virtual int      TBLcardcnt()=0;
  virtual int      TBLcntcnt()=0;
  virtual void     TBLidxdel(int idx, char*& error)=0;
  virtual int      TBLgetidx(card_id, char*& error)=0;
  virtual mac_addr TBLgetmacaddr(int idx, char*& error)=0;
  virtual ip_addr  TBLgetipaddr(int idx, char*& error)=0;
  virtual int64*   TBLgetcnt(card_id, int counter, char*& error)=0;

  // Should print the given string
  virtual void print(const char* string)=0;
};
