// This defines an interface to the pcap library. The library is used by
// daemon process to read packets from network device.

extern "C" {
#include <pcap.h>
}

typedef int ip_port;

class PcapInterface {
  char interface[20];
  char errmsg[PCAP_ERRBUF_SIZE];
  pcap_t *ph;
  bpf_program filter;
  int datalink;
  
  public:
  PcapInterface()  { ph=0;  interface[0]='\x0'; }
  ~PcapInterface() { if(ph) pcap_close(ph); }

  struct Packet {
    mac_addr   maca_src;   // In network format
    mac_addr   maca_dst;   // In network format
    ip_addr    ip_src;     // In network format
    ip_addr    ip_dst;     // In network format
    ip_port    port_src;   // In network format
    ip_port    port_dst;   // In network format
    int        ip_len;     // Length of IP part of packet
    Time       time;       // The timestamp of the packet
    char       proto;
  };  
  
  // Print an ascii representation of the packet to buf:
  void printPacket(char* buf, int buflen, const Packet& p);

  // This inits this object.
  //   filter:  A filter expression. If 0 no filter is used.
  //   netdev:  The device to use. If 0 a default device is used.
  // Returns an error message or 0
  char* init(char* filter, char* netdev, int promiscmode);

  // After init is called these can be called:
  
  // Returns the name of the used device:
  char* getDev() { return interface; }
  
  // Sets the parameter to the next packet or returns an errormessage:
  char* nextPacket(Packet&,LogFile* lf);    
};
