// This module can be used to control signal handling.

// Block for all signals:
extern void blockSignals();

// Unblock signals. Note that multiple calls to blockSignals will require
// multiple calls to unblockSignals to actually unblock the signals.
extern void unblockSignals();

// The following are used to register signal handlers for various
// events.

enum signalType {signalTerm,signalHup};
typedef void (*signal_handler)(void*);

extern void registerSignalHandler(void*, signal_handler, signalType type);
extern void unregisterSignalHandler(void*, signal_handler);
