AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])    

AC_DEFUN(AC_HAVE_STRUCT_ICMP,
[
 AC_CACHE_CHECK([if we have BSD-style struct icmp], ac_cv_have_icmp, [ 
 ac_have_icmp=no
 ac_cv_have_icmp=no
 AC_TRY_COMPILE([
 #include <sys/types.h>
 #include <netinet/in_systm.h>
 #include <netinet/in.h>
 #include <netinet/ip.h>
 #include <netinet/ip_icmp.h>], [struct icmp icp; icp.icmp_type=0], 
   ac_cv_have_icmp="yes" ac_have_icmp="yes") 
 ])
])

AC_DEFUN(AC_HAVE_STRUCT_ICMPHDR,
[
 
 AC_CACHE_CHECK([if we have linux struct icmphdr], ac_cv_have_icmphdr, [ 
 ac_have_icmphdr=no
 ac_cv_have_icmphdr=no
 AC_TRY_COMPILE([
 #include <sys/types.h>
 #include <netinet/in_systm.h>
 #include <netinet/in.h>
 #include <netinet/ip.h>
 #include <netinet/ip_icmp.h>], [struct icmphdr icp; icp.type=0], 
   ac_cv_have_icmphdr="yes" ac_have_icmphdr="yes") 
 ])
])

AC_DEFUN(AC_HAVE_STRUCT_UDPBSD,
[
 AC_CACHE_CHECK([if we have BSD-style struct udphdr], ac_cv_have_udpbsd, [ 
 ac_have_udpbsd=no
 ac_cv_have_udpbsd=no
 AC_TRY_COMPILE([
 #include <sys/types.h>
 #include <netinet/in_systm.h>
 #include <netinet/in.h>
 #include <netinet/ip.h>
 #include <netinet/udp.h>], [struct udphdr icp; icp.uh_sport=0;], 
   ac_cv_have_udpbsd="yes" ac_have_udpbsd="yes") 
 ])
])

AC_DEFUN(AC_HAVE_STRUCT_UDP,
[
 AC_CACHE_CHECK([if we have struct udphdr], ac_cv_have_udp, [ 
 ac_have_udp=no
 ac_cv_have_udp=no
 AC_TRY_COMPILE([
 #include <sys/types.h>
 #include <netinet/in_systm.h>
 #include <netinet/in.h>
 #include <netinet/ip.h>
 #include <netinet/udp.h>], [struct udphdr icp; icp.source=0;], 
   ac_cv_have_udp="yes" ac_have_udp="yes") 
 ])
])


AC_DEFUN(AC_PATH_LIBXPM,
[

AC_MSG_CHECKING([for libXpm])
ac_xpm_includes=NO
ac_xpm_libraries=NO
xpm_libraries=""
xpm_includes=""

AC_ARG_WITH(xpm-includes,
	[ --with-xpm-includes		where the include files for libXpm are],
	[ac_xpm_includes="$withval"])

AC_ARG_WITH(xpm-libraries,
	[ --with-xpm-libraries		where the library files for libXpm are],
	[ ac_xpm_libraries="$withval" ])

if test "$ac_xpm_includes" = "NO" || test "$ac_xpm_libraries" = "NO"; then

AC_CACHE_VAL(ac_cv_have_libxpm, [
 if test "$ac_xpm_includes" = NO; then
 AC_TRY_CPP( [#include <X11/xpm.h>],
  [ac_xpm_includes=], [
  xpm_incdirs="$x_includes /opt/GBxpm \
  /usr/X11/include          \
    /usr/X11R6/include        \
    /usr/X11R5/include        \
    /usr/X11R4/include        \
    /usr/include/X11          \
    /usr/include/X11R6        \
    /usr/include/X11R5        \
    /usr/include/X11R4        \
    /usr/local/X11/include    \
    /usr/local/X11R6/include  \
    /usr/local/X11R5/include  \
    /usr/local/X11R4/include  \
    /usr/local/include/X11    \
    /usr/local/include/X11R6  \
    /usr/local/include/X11R5  \
    /usr/local/include/X11R4  \
    /usr/X386/include         \
    /usr/x386/include         \
    /usr/XFree86/include/X11  \
    /usr/include              \
    /usr/local/include        \
    /usr/unsupported/include  \
    /usr/athena/include       \
    /usr/local/x11r5/include  \
    /usr/lpp/Xamples/include  \
    /usr/openwin/include      \
    /usr/openwin/share/include"
  AC_FIND_FILE(X11/xpm.h, $xpm_incdirs, xpm_incdir)
  ac_xpm_includes=$xpm_incdir
 fi
 ])
 TEMP_LIBS=$LIBS;
 LIBS="$LIBS -lXpm"
 if test "$ac_xpm_libraries" = NO; then
 AC_TRY_LINK(, [ XCreatePixmapFromData() ],
 [ac_xpm_libraries=], [
  LIBS=$TEMP_LIBS
   xpm_libdirs="$x_libraries $x_libraries/X11 /opt/GBxpm/lib
    /usr/X11/lib          \
    /usr/X11R6/lib        \
    /usr/X11R5/lib        \
    /usr/X11R4/lib        \
    /usr/lib/X11          \
    /usr/lib/X11R6        \
    /usr/lib/X11R5        \
    /usr/lib/X11R4        \
    /usr/local/X11/lib    \
    /usr/local/X11R6/lib  \
    /usr/local/X11R5/lib  \
    /usr/local/X11R4/lib  \
    /usr/local/lib/X11    \
    /usr/local/lib/X11R6  \
    /usr/local/lib/X11R5  \
    /usr/local/lib/X11R4  \
    /usr/X386/lib         \
    /usr/x386/lib         \
    /usr/XFree86/lib/X11  \
    /usr/lib              \
    /usr/local/lib        \
    /usr/unsupported/lib  \
    /usr/athena/lib       \
    /usr/local/x11r5/lib  \
    /usr/lpp/Xamples/lib  \
    /lib/usr/lib/X11      \
    /usr/openwin/lib      \
    /usr/openwin/share/lib "
   AC_FIND_FILE(libXpm.a, $xpm_libdirs, xpm_libdir)
   ac_xpm_libraries=$xpm_libdir
   fi
 ])
  if test "$ac_xpm_includes" = NO; then
  	AC_MSG_ERROR([libXpm includes not found])
  fi
  
  if test "$ac_xpm_libraries" = NO; then
        AC_MSG_ERROR([libXpm libraries not found])
  fi
   
])
fi 
  xpm_includes=$ac_xpm_includes
  xpm_libraries=$ac_xpm_libraries
  
  AC_MSG_RESULT([libraries $xpm_libraries, headers $xpm_includes])
  
  AC_SUBST(xpm_includes)
  AC_SUBST(xpm_libraries)
  
])

