#ifndef __WMNETMON_H__
#define __WMNETMON_H__

#include "pinger.h"
#include "list.h"
#include "X11/Xlib.h"

typedef struct
{
	char hostname[80];
	pinger_host *h;
	int x,y;
	int lx,ly;
	int flags;
} hostmon;

#define FLAG_DONTWARN 1
#define FLAG_IGNORE_ON_MUTE (1<<6)
#define FLAG_MUTED (1<<7)
#define MAX_HOSTNAME 50

extern ListItem hosts;
extern Window Root;
extern char *wmnetmon_mask_bits;

#define MW_EVENTS   (ExposureMask | StructureNotifyMask | \
EnterWindowMask | LeaveWindowMask | PointerMotionMask | ButtonPressMask | \
ButtonReleaseMask )

#define XLEDS 9 
#define YLEDS 7

extern int poll_time;
extern int poll_yellowtime;
extern int poll_redtime;
extern int default_flags;
extern char soundfile[],soundplayer[];

void writetextat(int x,int y, char *string);

typedef struct led *ledarray[XLEDS][YLEDS];

extern ledarray leds;
extern int debug;
hostmon * add_host(pinger*,char*,char*);

#endif
