/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "DiccionarioBase.h"
#include "intern.h"
#include <QConfig.h>
#include "qfunciones.h"
#include <qfile.h>
#include <qtextstream.h>
#include <stdlib.h> //mktemp

#ifdef USE_PIPES
#include <unistd.h>
#include <stdio.h>
#endif

bool DiccionarioBase::html_simple_header=true; 
bool DiccionarioBase::no_internal_links=false;
bool DiccionarioBase::html_use_br=false;
QString DiccionarioBase::base_page="wordtrans.php";
QString DiccionarioBase::additional_options="?";
bool DiccionarioBase::no_gui=false;
QString DiccionarioBase::color_header="#F8FFD2";
bool DiccionarioBase::usar_tabla=true;

//Chapuza para cambiar el font en Qt 3
#if QT_VERSION >= 300
QString DiccionarioBase::font_string="helvetica";
#endif

DiccionarioBase::DiccionarioBase() {
	setTipo( DiccionarioBase::Text_dict );

	alias= _("give_me_a_name");
	diccionario="/usr/share/i2e/i2e.dict";

	setPersonal( _(".wordtrans/give_me_a_name.dict") );

	separador=" : ";

	idioma1= _("language1");
	idioma2= _("language2");

	//icono_idioma1="/usr/share/wordtrans/i2e.xpm";
	//icono_idioma2="/usr/share/wordtrans/e2i.xpm";

	icono_idioma1="/usr/share/wordtrans/unknown.xpm";
	icono_idioma2="/usr/share/wordtrans/unknown.xpm";

	borrado = false;

	busqueda_inversa=false;
	case_sensitive=true;
	palabras_completas=false;
	ignora_acentos=false;

	utf8=false;

	trabajando=false;

	//QCadena nombre_conf= "/tmp/" + alias + ".conf";

	setError("");

	desc.clear();
	desc.append( "<h2>Multi Language Word Translator (wordtrans)</h2>" );
	desc.append( _("This dictionary has no description.") );
	desc.append( "" );
	desc.append( _("This description can be changed by selecting the <b>Dictionaries->Edit</b> option.") );
	desc.append( _("You can add all lines you want, there's no limit, but I suggest that it is not so long.") );
	desc.append( "" );
	desc.append( _("The description is intended for copyright notices and a brief description of the dictionary.") );
	desc.append( "" );
	desc.append( "<hr/>\n(c) 2000 Ricardo Villalba" );

	bestMatch="";
	n_matches=0;

	conf = new QConfig( "/tmp/ponmenombre.conf" );

#if QT_VERSION >= 210
	DiccionarioBase::html_simple_header=false; 
#else
	DiccionarioBase::html_simple_header=true; 
#endif

	//Font
	f_family = QString::null;
	f_pointSize = 0;
	f_weight = 0;
	f_italic = false;
	f_underline = false;
	f_strikeout = false;
	f_charset = 0;
}

DiccionarioBase::~DiccionarioBase() {
	delete conf;
}

void DiccionarioBase::setPersonal(const QString& fichero) {
	personal=fichero;
	personal_dict= qNomPersonal(personal);
}

QString DiccionarioBase::getFullName() {
	QString texto = getIdioma1();
	texto += " <-> ";
	texto += getIdioma2();
	texto += " (" + getAlias() + ")";
	return texto;
}

void DiccionarioBase::setFileName(const QString& fichero) {
	conf->setFileName(fichero.latin1());
}

/*
bool DiccionarioBase::busca(const QString& palabra, QStringList & resultado, 
                            bool con_formato=false) {
	return false;
}
*/

bool DiccionarioBase::busca(const QString& palabra, QString & resultado,             
                            bool con_formato) {
	return false;
}

bool DiccionarioBase::aprende(const QString& texto_idioma1, const QString& texto_idioma2) {
	return false;
}

void DiccionarioBase::save() {
}

void DiccionarioBase::load(const QString& fichero) {
}

bool DiccionarioBase::update() { 
	return true;
}

QString DiccionarioBase::getGeneralInfo(bool con_formato) {
	return _("<p>Ehh... sorry, this dictionary has no information about any server.</p>");
}

QString DiccionarioBase::getDictionaryInfo(bool con_formato) {
	return _("<p>Ehh... sorry, this dictionary has no information about any database.</p>");
}

bool DiccionarioBase::exec_command(QCString orden, QString & resultado) {
#ifdef USE_PIPES
	FILE *stream;
	//debug("Executing '%s' via popen.", orden.data() );
	stream=popen( orden.data(), "r" );
	if (stream==NULL) return false;
#else
	static char tempfile[255];
	strcpy(tempfile,"/tmp/wordtrans.XXXXXX");

	if (mktemp(tempfile)==NULL) {
		//setError( _("Cannot create temporary file!!!") );
		//warning( error.latin1() );
		warning( "Cannot create temporary file!!!" );
		return false;
	}

	orden += " > ";
	orden += tempfile;
	orden += " 2>&1";

	//debug("comando: '%s'", orden.data() );
	ejecuta( orden.data() );
#endif

#ifdef USE_PIPES
	if (stream!=NULL) {
		QTextStream t( stream, IO_ReadOnly);
#else
	//Ahora leemos los datos del fichero temporal
	QFile f( tempfile );
	if ( f.open(IO_ReadOnly) ) {    // file opened successfully
		QTextStream t( &f );        // use a text stream
#endif
		t.setEncoding( QTextStream::Latin1 );
		//t.setEncoding( QTextStream::UnicodeUTF8 );

		//QString texto;
		//texto= t.read();
		//resultado += texto;
		resultado += t.read();
		/*
		while ( !t.eof() ) {        // until end of file...
			linea = t.readLine();       // line of text excluding '\n'
			resultado += linea;
		}
		*/
#ifdef USE_PIPES
		pclose(stream);
#else
		f.close();
#endif
	}

#ifndef USE_PIPES
	//Borra el fichero temporal
	QFile::remove( tempfile );
#endif

	return true;
}


QCString filtraLocale(const char *l) {
	QCString locale = l;
	/*
	int p = locale.find('@',0);
	while (p!=-1) {
		locale.replace(p, 1, "_arroba_");
		p = locale.find('@',0);
	}
	*/

	if ( locale.length() >= 2 ) {
		locale = locale.left(2);
		qDebug("locale = %s", locale.data() );
	}

	return locale;
}

void DiccionarioBase::save_desc() {
	QCString locale=filtraLocale( getLocale() );
	bool hay_locale=(!locale.isEmpty());

	if (hay_locale) {
		QCString l = "Descripcion_" + locale;
		conf->setGroup( l.data() );
		//debug( "Note: saving description in localized section %s "
		//	   "in the\nconfiguration file.", l.data() );
	} else {
		conf->setGroup("Descripcion");
	}

	conf->writeNumEntry("lineas", desc.count() );

	QCString nombre;
	int n=0;
	for (QStringList::Iterator it = desc.begin(); it != desc.end(); ++it) {
		nombre.sprintf( "linea%d", n );
		conf->writeEntry( nombre.data(), (*it).latin1() );
		n++;
	}
}

void DiccionarioBase::load_desc() {
	QCString locale=filtraLocale( getLocale() );
	bool hay_locale=(!locale.isEmpty());

	int lineas;

	if (hay_locale) {
		QCString l= "Descripcion_" + locale;
		conf->setGroup( l.data() );
		lineas=	conf->readNumEntry( "lineas", -1 );
		if (lineas==-1) {
			hay_locale=false;
			debug( "Note: section %s not found in the configuration file.\n"
				   "Using default section.", l.data() );
		}
	}

	if (!hay_locale) {
		conf->setGroup("Descripcion");
		lineas=conf->readNumEntry("lineas", 0 );
	}

	QCString nombre;
	QString linea;

	for (int n=0;n < lineas; n++ ) {
		if (n==0) desc.clear();

		nombre.sprintf( "linea%d", n );
		linea=conf->readEntry( nombre.data(), "" );
		desc.append( linea );
	}
}

void DiccionarioBase::save_font() {
	conf->setGroup("Font");

	conf->writeEntry( "family", f_family.latin1() );
	conf->writeNumEntry( "pointsize", f_pointSize );
	conf->writeNumEntry( "weigtht", f_weight );
	conf->writeBoolEntry( "italic", f_italic );
	conf->writeBoolEntry( "bold", f_bold );
	conf->writeBoolEntry( "underline", f_underline );
	conf->writeBoolEntry( "strikeout", f_strikeout );
	conf->writeNumEntry( "charset", f_charset );
}

void DiccionarioBase::load_font() {
	conf->setGroup("Font");

	f_family= conf->readEntry( "family", "Helvetica" );
	f_pointSize= conf->readNumEntry( "pointsize", 12 );
	f_weight= conf->readNumEntry( "weigtht", 50 );
	f_italic= conf->readBoolEntry( "italic", false );
	f_bold= conf->readBoolEntry( "bold", false );
	f_underline= conf->readBoolEntry( "underline", false );
	f_strikeout= conf->readBoolEntry( "strikeout", false );
	f_charset= conf->readNumEntry( "charset", 0 );
}

