/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _QBABYDICCIONARIO_H_
#define _QBABYDICCIONARIO_H_

#include "DiccionarioBase.h"
#ifndef NO_LIBBAB
#include "libbab/libbab.h"
#endif

class QBabyDiccionario : public DiccionarioBase
{

public:
	QBabyDiccionario();
	virtual ~QBabyDiccionario();

	virtual QString getFullName();

	//virtual bool busca(const QString& palabra, QStringList & resultado, 
    //                   bool con_formato=false);

	virtual bool busca(const QString& palabra, QString & resultado, 
                       bool con_formato=false);

	virtual bool aprende(const QString& texto_idioma1, const QString& texto_idioma2);
	virtual bool puedeAprender() { return false; };

	virtual void save();
    virtual void load(const QString& fichero);

	virtual bool canSelectPalabrasCompletas() { return false; };
	virtual bool canSelectCaseSensitive() { return false; };
	virtual bool canSelectInvertirResultados() { return false; };

	//virtual bool isBabyDict() { return true; };
	//virtual bool isDictdDict() { return false; };
    //virtual bool isTextDict() { return false; };

	virtual bool update();

private:
#ifndef NO_LIBBAB
	babylon * app_translator;
	QCString dict_charset;
	//bool usar_tabla;
#endif
};

#endif
