/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "QEditaDiccionario.h"
#include "intern.h"

#include <qwhatsthis.h>

QEditaDiccionario::QEditaDiccionario(
	DiccionarioBase *dictionary, bool nuevo,
	QWidget * parent,
	const char * name,
	WFlags f) : QTabDialog( parent, name, true, f )
{
	dict=dictionary;
	nuevo_dict=nuevo;

	setCaption( _("Edit dictionary") );

	setHelpButton( _("&Help") );
	connect( this, SIGNAL( helpButtonPressed() ),
             this, SLOT( ayuda() ) );

	setOkButton( _("&Ok") );
	setCancelButton( _("&Cancel") );

	if (dict->getTipo()==DiccionarioBase::Dict_dict) {
		dict_prefs= new DictPrefs( (QDictDiccionario*) dict, nuevo_dict, this, "dict_prefs");
		addTab( dict_prefs, _("&Main") );
	}
	else {
		text_prefs = new TextPrefs( dict, nuevo_dict, this, "text_prefs" );
		addTab( text_prefs, _("&Main") );
	}
	
	desc_edit = new DescEdit( this, "desc_edit" );
	desc_edit->setText( dict->getDesc() );

	addTab( desc_edit, _("&Description") );

//#ifndef HAVE_QT2
//	connect( this, SIGNAL( applyButtonPressed() ), this, SLOT( accept() ) );
//	connect( this, SIGNAL( cancelButtonPressed() ), this, SLOT( reject() ) );
//#endif

	/*
	int w=554;
	int h=402; //344+50;
	*/
	int w= 479;
	int h= 347;
	resize( w, h );
	setMinimumSize( w, h );
	setMaximumSize( w, h );
}

QEditaDiccionario::~QEditaDiccionario() {
	debug("Destruyendo QEditaDiccionario");

	//debug("width: %d", width() );
	//debug("height %d", height() );
}

void QEditaDiccionario::accept() {

	bool ok;
	
	if (dict->getTipo()==DiccionarioBase::Dict_dict)
		ok=dict_prefs->aceptar();
	else
		ok=text_prefs->aceptar();

	if (ok) {
		//QSize s=size();
		//debug("ancho: %d, alto: %d", s.width(), s.height() );

		dict->setDesc( desc_edit->getText() );
		done(1);
	}
}

void QEditaDiccionario::reject() {
	done(2);
}

void QEditaDiccionario::ayuda() {
	QWhatsThis::enterWhatsThisMode();
	/*
	if (tb==NULL) tb = new QTextBrowser( 0, "TextBrowser de QEditaDiccionario");
	tb->setText( _( "<qt type\"=detail\"><b>Alias:</b>... </qt>") );
	tb->show();
	*/
}

#include "QEditaDiccionario.moc.cpp"

