

#include "salidas.h"
#include <qstring.h>
#include <qtextcodec.h>

#include <stdio.h>

QTextCodec * Salidas::codec = NULL;
bool Salidas::show_messages = false;

void Salidas::setCodec( const char *codec_name, int accuracy) {
	codec = QTextCodec::codecForName( codec_name, accuracy );
}

void Salidas::sprint( const QString & texto ) {
	if (codec!=NULL) 
		printf( "%s", codec->fromUnicode( texto ).data() );
	else
		printf( "%s", texto.latin1() );
}

void Salidas::sprintln( const QString & texto ) {
	if (codec!=NULL) 
		printf( "%s\n", codec->fromUnicode( texto ).data() );
	else
		printf( "%s\n", texto.latin1() );
}

void Salidas::messageOutput( QtMsgType type, const char *msg ) {
	if (!show_messages) return;

	switch ( type ) {
		case QtDebugMsg:
			fprintf( stderr, "Debug: %s\n", msg );
			break;
		case QtWarningMsg:
			fprintf( stderr, "Warning: %s\n", msg );
			break;
		case QtFatalMsg:
			fprintf( stderr, "Fatal: %s\n", msg );
			//abort();                        // dump core on purpose
	}
}

void Salidas::installDebugHandler() {
	qInstallMsgHandler( Salidas::messageOutput );
}

void sprint( const QString & texto ) { Salidas::sprint(texto); }
void sprintln( const QString & texto ) { Salidas::sprintln(texto); }

