#include "wizard_page1Data.h"

#include <qfileinfo.h>
#include <qfiledialog.h>
#include <qlineedit.h>

/* 
 *  Constructs a WizardPage1 which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
WizardPage1::WizardPage1( QWidget* parent,  const char* name, WFlags fl )
    : WizardPage1Data( parent, name, fl )
{

	connect(fichero, SIGNAL(textChanged(const QString&)), 
            this, SLOT(validar_fichero(const QString&)) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
WizardPage1::~WizardPage1()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * protected slot
 */
void WizardPage1::choose_file()
{
	QString f = QFileDialog::getOpenFileName();
	if ( ! f.isEmpty() ) {
		fichero->setText( f );
	}
}

void WizardPage1::validar_fichero(const QString& fichero) {
	QFileInfo f(fichero);
	bool exists = ( (f.exists()) && (f.isFile()) );
	emit valid_file( exists );
}

QString WizardPage1::getFile() {
	return fichero->text();
}

#include "wizard_page1.moc.cpp"

#include "wizard_page1Data.cpp"
#include "wizard_page1Data.moc.cpp"
