/* message.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: message.h,v 1.20 2005/05/15 13:46:43 ralf Exp $ */

#ifndef MESSAGE_H
#define MESSAGE_H

#include "aguixdefs.h"
#include <X11/Xlib.h>

class Button;
class ChooseButton;
class StringGadget;
class GUIElement;
class CycleButton;
class AWindow;
class FieldListView;
class KarteiButton;
class Slider;
class Widget;

typedef struct message
{
  int type;
  enum { NONE, TIMEREVENT } specialType;
  GUIElement *lockElement;
  bool ack;
  int loop;

  Window window;
  KeySym key;
  unsigned int keystate;
  unsigned int button;
  int mousex,mousey;
  int mouserx,mousery;
  int gadgettype; // brauchen wir eigentlich nicht mehr, da jedes GUIElement einen Typ hat
  void *gadget;  // kann auch GUIElement *gadget werden
  Time time;
  char *keybuf;
  int x, y, width, height;
} Message;

enum {AG_NONE,AG_KEYPRESSED,AG_KEYRELEASED,AG_MOUSEPRESSED,AG_MOUSERELEASED,AG_MOUSECLICKED,AG_MOUSEMOVE,
      AG_EXPOSE,AG_CLOSEWINDOW,AG_ENTERWINDOW,AG_LEAVEWINDOW,AG_BUTTONPRESSED,AG_BUTTONRELEASED,
      AG_BUTTONCLICKED,AG_CHOOSEPRESSED,AG_CHOOSERELEASED,AG_CHOOSECLICKED,
      AG_STRINGGADGET_ACTIVATE,AG_STRINGGADGET_DEACTIVATE,AG_STRINGGADGET_OK,
      AG_STRINGGADGET_CANCEL,AG_STRINGGADGET_CONTENTCHANGE,AG_STRINGGADGET_CURSORCHANGE,
      AG_SIZECHANGED,
      AG_DND_START,AG_DND_END,AG_DND_CANCEL,
      AG_CYCLEBUTTONCLICKED,
      AG_FIELDLV_ONESELECT,AG_FIELDLV_MULTISELECT,AG_FIELDLV_PRESSED,AG_FIELDLV_HEADERCLICKED,
      AG_KARTEIBUTTONCLICKED,
      AG_SLIDER_PRESSED, AG_SLIDER_CHANGED };

typedef struct agkey {
  int type;
  Window window;
  KeySym key;
  unsigned int keystate;
  char *keybuf;
} AGKey;

typedef AGKey AGKeyPressed;
typedef AGKey AGKeyReleased;

typedef struct agmouse {
  int type;
  Window window;
  unsigned int button;
  int x,y;
  Time time;
} AGMouse;

typedef AGMouse AGMousePressed;
typedef AGMouse AGMouseReleased;
typedef AGMouse AGMouseClicked;
typedef AGMouse AGMouseMove;

typedef struct agexpose {
  int type;
  Window window;
  int x,y;
  int w,h;
} AGExpose;

typedef struct agclosewindow {
  int type;
  Window window;
} AGCloseWindow;

typedef struct agcross {
  int type;
  Window window;
} AGCross;

typedef AGCross AGEnterWindow;
typedef AGCross AGLeaveWindow;

typedef struct agbutton {
  int type;
  Button *button;
  int state;
} AGButton;

typedef AGButton AGButtonPressed;
typedef AGButton AGButtonReleased;
typedef AGButton AGButtonClicked;

typedef struct agchoose {
  int type;
  ChooseButton *button;
  bool state;
} AGChoose;

typedef AGChoose AGChoosePressed;
typedef AGChoose AGChooseReleased;
typedef AGChoose AGChooseClicked;

typedef struct agstringgadget {
  int type;
  StringGadget *sg;
  bool ok;  /* only set for _DEACTIVATE
	     * true when Return pressed, false otherwise (escape pressed, only deactivated...)
	     */
} AGStringGadget;

typedef AGStringGadget AGStringGadgetActivate;
typedef AGStringGadget AGStringGadgetDeactivate;
typedef AGStringGadget AGStringGadgetOk;
typedef AGStringGadget AGStringGadgetCancel;
typedef AGStringGadget AGStringGadgetContentChange;
typedef AGStringGadget AGStringGadgetCursorChange;

typedef struct agsizechange {
  int type;
  Window window;
  int neww,newh;
} AGSizeChange;

typedef struct agdnd {
  int type;
  int relx,rely;
  Widget *element;
  AWindow *window;
  struct {
    void *voidP;
    int value;
    class FieldLVRowData *rowDataP;
  } specialinfo;
} AGDND;

typedef AGDND AGDNDSTART;
typedef AGDND AGDNDEND;
typedef AGDND AGDNDCANCEL;

typedef struct agcyclebutton {
  int type;
  CycleButton *cyclebutton;
  int option;
} AGCycleButton;

typedef AGCycleButton AGCycleButtonClicked;

typedef struct agfieldlv {
  int type;
  FieldListView *lv;
  int row;
  Time time;
  bool mouse;
  unsigned int button;
} AGFieldLV;

typedef AGFieldLV AGFieldLVOneSelect;
typedef AGFieldLV AGFieldLVMultiSelect;
typedef AGFieldLV AGFieldLVPressed;

typedef struct agkarteibutton {
  int type;
  KarteiButton *karteibutton;
  int option;
} AGKarteiButton;

typedef AGKarteiButton AGKarteiButtonClicked;

typedef struct agslider {
  int type;
  Slider *slider;
  int offset;
  Time time;
  bool mouse;
} AGSlider;

typedef AGSlider AGSliderChanged;
typedef AGSlider AGSliderPressed;

typedef union agmessage {
  int type;
  AGKey key;
  AGMouse mouse;
  AGExpose expose;
  AGCloseWindow closewindow;
  AGCross cross;
  AGButton button;
  AGChoose choose;
  AGStringGadget stringgadget;
  AGSizeChange size;
  AGDND dnd;
  AGCycleButton cyclebutton;
  AGFieldLV fieldlv;
  AGKarteiButton karteibutton;
  AGSlider slider;
  long direct[20];
} AGMessage;

Message *AGUIX_allocMessage();
void AGUIX_freeMessage( Message *);
AGMessage *AGUIX_allocAGMessage();
void AGUIX_freeAGMessage( AGMessage *);

#endif
