/* renameop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: renameop.cc,v 1.13 2005/10/19 18:02:51 ralf Exp $ */

#include "renameop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *RenameOp::name="RenameOp";

RenameOp::RenameOp() : FunctionProto()
{
}

RenameOp::~RenameOp()
{
}

RenameOp*
RenameOp::duplicate() const
{
  RenameOp *ta=new RenameOp();
  return ta;
}

bool
RenameOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
RenameOp::getName()
{
  return name;
}

int
RenameOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmoderename( msg );
    }
  }
  return 0;
}

const char *
RenameOp::getDescription()
{
  return catalog.getLocaleCom(29);
}

int
RenameOp::normalmoderename( ActionMessage *am )
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  struct NM_renameorder renorder;
  NM_specialsourceExt *specialsource=NULL;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;
  if(lm1->isType("NormalMode")!=true) return 1;
  nm1=(NormalMode*)lm1;
  
  memset( &renorder, 0, sizeof( renorder ) );
  if(am->mode==am->AM_MODE_ONLYACTIVE)
    renorder.source=renorder.NM_ONLYACTIVE;
  else if(am->mode==am->AM_MODE_DNDACTION) {
    // insert DND-element into list
    renorder.source=renorder.NM_SPECIAL;
    renorder.sources=new std::list<NM_specialsourceExt*>;
    specialsource = new NM_specialsourceExt( NULL );
    specialsource->row=-1;
    //TODO: specialsource nach am besetzen (je nachdem wir ich das realisiere)
    renorder.sources->push_back(specialsource);
  } else if(am->mode==am->AM_MODE_SPECIAL) {
    renorder.source=renorder.NM_SPECIAL;
    renorder.sources=new std::list<NM_specialsourceExt*>;
    specialsource = new NM_specialsourceExt( am->getFE() );
    specialsource->row=-1;
    renorder.sources->push_back(specialsource);
  } else
    renorder.source=renorder.NM_ALLENTRIES;

  nm1->renamef(&renorder);
  if(renorder.source==renorder.NM_SPECIAL) {
    if ( specialsource != NULL ) delete specialsource;
    delete renorder.sources;
  }

  return 0;
}

