// $Id: Tool.h,v 1.4 2001/10/29 23:08:48 nekeme Exp $
#ifndef WE_TOOL_H
#define WE_TOOL_H

#include "World.h"


// forward declaration
class Command;


class Tool
{
   protected:
      World* m_World;
      
      inline int ClampX(int x) const
      { 
	 return (x<0) ? 0 :
	    ((int(m_World->m_SizeX) <= x) ? (m_World->m_SizeX - 1) : x);
      } 
      
      inline int ClampZ(int z) const
      { 
	 return (z<0) ? 0 :
	    ((int(m_World->m_SizeZ) <= z) ? (m_World->m_SizeZ - 1) : z); 
      } 
    
      inline void ClampCoord(int& x, int &z) const
      {
	 if (x < 0) x = 0;
	 if (int(m_World->m_SizeX) <= x) x = m_World->m_SizeX - 1;

	 if (z < 0) z = 0;
	 if (int(m_World->m_SizeZ) <= z) z = m_World->m_SizeZ - 1;
      }
      
  public:
    Tool(World* hf) : m_World(hf) {}
    virtual ~Tool() {}

    /// Sets current height field. This should be set only by Application.
    // This function may be removed in the future, Do not rely upon it
    void SetWorld(World* hf) {m_World = hf;};
    
    /// Apply tool at (x,z)
    virtual void Apply(int x, int z) = 0;

    virtual void Apply3D(Ark::Vector3 newpos, const Ark::Collision &col) {}

    /// Update or reset tool
    virtual void Update() = 0;

  public:
    /// Create a command with a correct state.
    virtual Command* CreateCommand() = 0;

};

#endif // WE_TOOL_H
