/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	Inline_H
#define	Inline_H

#include <cmath>
#include <complex>
using namespace std;

#if 0
/*
 * Absolute value of a complex number, using a fast algorithm from
 * http://www.dspguru.com by Andre Lodwig.
 */
inline double CABS(double real, double imag)
{
	double a = ::fabs(real);
	double b = ::fabs(imag);

	if (b > a) {
		double temp = a;
		a = b;
		b = temp;
	}

	double alpha, beta;
	if ((a * 0.267949) > b) {
		alpha = 0.994843;
		beta  = 0.131165;
	} else if ((a * 0.577350) > b) {
		alpha = 0.926910;
		beta  = 0.384003;
	} else {
		alpha = 0.796295;
		beta  = 0.610565;
	}

	return alpha * a + beta * b;
}

inline double CABS(const complex<double>& in)
{
	double a = ::fabs(in.real());
	double b = ::fabs(in.imag());

	if (b > a) {
		double temp = a;
		a = b;
		b = temp;
	}

	double alpha, beta;
	if ((a * 0.267949) > b) {
		alpha = 0.994843;
		beta  = 0.131165;
	} else if ((a * 0.577350) > b) {
		alpha = 0.926910;
		beta  = 0.384003;
	} else {
		alpha = 0.796295;
		beta  = 0.610565;
	}

	return alpha * a + beta * b;
}
#endif

inline double CABS(double real, double imag)
{
	return ::sqrt(real * real + imag * imag);
}

inline double CABS(const complex<double>& in)
{
	return ::sqrt(in.real() * in.real() + in.imag() * in.imag());
}

inline double CPHASE(double real, double imag)
{
	return ::atan2(real, imag);
}

inline double CPHASE(const complex<double>& in)
{
	return ::atan2(in.real(), in.imag());
}

inline double RAD(double angle)
{
	return (angle / 180.0) * M_PI;
}

inline double DEG(double angle)
{
	return (angle / M_PI) * 180.0;
}

#endif
