/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44SunMoonDisplay_H
#define	JT44SunMoonDisplay_H

#include "common/SunMoonPanel.h"

#include <wx/wx.h>

const int Choice_Band = 438;

enum {
	Band_50MHz,
	Band_70MHz,
	Band_144MHz,
	Band_220MHz,
	Band_432MHz,
	Band_902MHz,
	Band_1296MHz,
	Band_2304MHz,
	Band_3400MHz,
	Band_5760MHz,
	Band_10368MHz,
	Band_24192MHz
};

class CJT44SunMoonDisplay : public wxPanel {
    public:
	CJT44SunMoonDisplay(wxWindow* parent, int id = -1, const wxString& locator = "IO93FB", int band = 144);
	virtual ~CJT44SunMoonDisplay();

	virtual void setBand(int band);
	virtual int  getBand() const;

    private:
	CSunMoonPanel* m_panel;
	wxChoice*      m_band;
};

#endif
