/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MLookups.h"

static const struct {
	wxChar c;
	int    n;
} jt6mTable[] = {
	{wxT('0'),  1}, {wxT('1'),  2}, {wxT('2'),  3}, {wxT('3'),  4},
	{wxT('4'),  5}, {wxT('5'),  6}, {wxT('6'),  7}, {wxT('7'),  8},
	{wxT('8'),  9}, {wxT('9'), 10}, {wxT('.'), 11}, {wxT(','), 12},
	{wxT(' '), 13}, {wxT('/'), 14}, {wxT('#'), 15}, {wxT('?'), 16},
	{wxT('$'), 17}, {wxT('A'), 18}, {wxT('a'), 18}, {wxT('B'), 19},
	{wxT('b'), 19}, {wxT('C'), 20}, {wxT('c'), 20}, {wxT('D'), 21},
	{wxT('d'), 21}, {wxT('E'), 22}, {wxT('e'), 22}, {wxT('F'), 23},
	{wxT('f'), 23}, {wxT('G'), 24},	{wxT('g'), 24}, {wxT('H'), 25},
	{wxT('h'), 25}, {wxT('I'), 26}, {wxT('i'), 26}, {wxT('J'), 27},
	{wxT('j'), 27}, {wxT('K'), 28}, {wxT('k'), 28}, {wxT('L'), 29},
	{wxT('l'), 29}, {wxT('M'), 30},	{wxT('m'), 30}, {wxT('N'), 31},
	{wxT('n'), 31}, {wxT('O'), 32}, {wxT('o'), 32}, {wxT('P'), 33},
	{wxT('p'), 33}, {wxT('Q'), 34}, {wxT('q'), 34}, {wxT('R'), 35},
	{wxT('r'), 35}, {wxT('S'), 36},	{wxT('s'), 36}, {wxT('T'), 37},
	{wxT('t'), 37}, {wxT('U'), 38}, {wxT('u'), 38}, {wxT('V'), 39},
	{wxT('v'), 39}, {wxT('W'), 40}, {wxT('w'), 40}, {wxT('X'), 41},
	{wxT('x'), 41}, {wxT('Y'), 42},	{wxT('y'), 42}, {wxT('Z'), 43},
	{wxT('z'), 43}};

CJT6MLookups::CJT6MLookups()
{
}

CJT6MLookups::~CJT6MLookups()
{
}

int CJT6MLookups::lookupChar(wxChar c) const
{
	for (int i = 0; i < 69; i++) {
		if (jt6mTable[i].c == c)
			return jt6mTable[i].n;
	}

	return -1;
}

wxChar CJT6MLookups::lookupTone(int n) const
{
	for (int i = 0; i < 69; i++) {
		if (jt6mTable[i].n == n)
			return jt6mTable[i].c;
	}

	return wxChar(0);
}

