/*
 *   Copyright (C) 2002 by Phil Karn KA9Q
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "DopplerTest.h"

#include "common/Exception.h"
#include "common/SoundFile.h"
#include "common/Doppler.h"

int main(int argc, char *argv[])
{
	if (argc < 5) {
		::fprintf(stderr, "Usage: DopplerTest <startf> <endf> <infile> <outfile>\n");
		return 1;
	}

	double   startFrequency = ::atof(argv[1]);
	double   endFrequency   = ::atof(argv[2]);
	wxString inFileName     = wxString(argv[3]);
	wxString outFileName    = wxString(argv[4]);

	try {
		CDopplerTest doppler(startFrequency, endFrequency, inFileName, outFileName);
		doppler.run();
	}
	catch (CException& ex) {
		::fprintf(stderr, "DopplerTest: error: %s\n", ex.getMessage().c_str());
		return 1;
	}
	catch (...) {
		::fprintf(stderr, "DopplerTest: an error has occured\n");
		return 1;
	}

	return 0;
}

CDopplerTest::CDopplerTest(double startFrequency, double endFrequency, const wxString& inFileName, const wxString& outFileName) :
m_startFrequency(startFrequency),
m_endFrequency(endFrequency),
m_inFileName(inFileName),
m_outFileName(outFileName)
{
}

CDopplerTest::~CDopplerTest()
{
}

void CDopplerTest::run()
{
	CSoundFile in(m_inFileName, 11025);
	in.openRead();

	CSoundFile out(m_outFileName, 11025, 8);
	out.openWrite();

	CDoppler doppler(11025);

	double* audio = new double[30 * 11025];
	int len = 30 * 11025;
	in.read(audio, len);

	if (len <= 0) {
		delete[] audio;
		in.close();
		out.close();
		return;
	}

	double* mix = new double[len];
	doppler.transform(audio, m_startFrequency, m_endFrequency, mix, len);

	out.write(mix, len);

	in.close();
	out.close();

	delete[] audio;
	delete[] mix;
}
