/*--------------------------------------------------------------------------*/
/* main                                                                     */
/*--------------------------------------------------------------------------*/

#ifndef __MY_MAIN_H
#define __MY_MAIN_H

/*--------------------------------------------------------------------------*/
/* defines                                                                  */
/*--------------------------------------------------------------------------*/

#define CELL_XSIZE      32
#define CELL_YSIZE      32
#define CANVAS_XCELLS   19
#define CANVAS_YCELLS   13
#define CANVAS_WIDTH    (CELL_XSIZE * CANVAS_XCELLS)
#define CANVAS_HEIGHT   (CELL_YSIZE * CANVAS_YCELLS)

#define CELL_X(x) ((x) * CELL_XSIZE)
#define CELL_Y(y) ((y) * CELL_YSIZE)

#define FPS             40

/*--------------------------------------------------------------------------*/
/* useful macros                                                            */
/*--------------------------------------------------------------------------*/

#define max(a,b) ((a) > (b) ? (a) : (b))
#define min(a,b) ((a) < (b) ? (a) : (b))
#define abs(a)   (((a) < 0) ? -(a) : (a))

/*--------------------------------------------------------------------------*/
/* functions                                                                */
/*--------------------------------------------------------------------------*/

int main_random(void);
void main_msgbox(char *msg);
int main_handle_events(int in_board_game);

/*--------------------------------------------------------------------------*/
/* variables                                                                */
/*--------------------------------------------------------------------------*/

extern int random_index;

#endif /* __MY_MAIN_H */
