#include "xev.h"
#include "enemy.h"

#define ANIM_PAT 61

PRIVATE char *fn[] = {
      "sio1.img",
      "sio2.img",
      "sio3.img",
      "sio4.img",
      "siol1.img",
      "siol2.img",
      "siol3.img",
      "siol4.img",
      "siol5.img",
      "sior1.img",
      "sior2.img",
      "sior3.img",
      "sior4.img",
      "sior5.img"
};

PRIVATE Pixmap pixmap[14];
PRIVATE Pixmap pixmap_mask[14];
PRIVATE GC gc[14];
PRIVATE int flag = 0;
PRIVATE int anim[2][ANIM_PAT] = { 
      {
	    3,3,2,2,2,2,1,1,1,1,
	    1,1,0,0,0,0,0,0,0,0,
	    3,3,3,3,3,3,3,3,3,3,
	    2,2,2,2,2,2,2,2,2,2,
	    2,2,2,2,2,2,4,4,4,5,
	    5,5,6,6,6,7,7,7,8,8,8 },
      {
	    3,3,2,2,2,2,1,1,1,1,
	    1,1,0,0,0,0,0,0,0,0,
	    3,3,3,3,3,3,3,3,3,3,
	    2,2,2,2,2,2,2,2,2,2,
	    2,2,2,2,2,2,9,9,9,10,10,
	    10,11,11,11,12,12,12,13,13,13}
};

void SioSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      XGCValues gcv;

      gcv.graphics_exposures = False;

      for(c_no = 0 ; c_no < 14 ; c_no++) {
            int x,y;

            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));
            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    DrawChar32(img , mask , gc[c_no],pixmap[c_no]);
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void SioFree()
{
      int i;

      for(i = 0 ; i < 14 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void SioInit(enemy_no)
     int enemy_no;
{
      int i;
      
      enemy[enemy_no].enemy_no = SIO;
      enemy[enemy_no].x.sht[UNION] = (flag ? 16:464);
      enemy[enemy_no].tmp1 = flag;

      if(!flag) {
	    flag = 1;
	    for(i = 0 ; i < ENEMY_MAX ; i++)
	      {
		    if(!enemy[i].enemy_no){
			  SioInit(i);
			  enemy[i].enemy_no = SIO;
			  break;
		    }
	      }
	    flag = 0;
      }
      
      enemy[enemy_no].y.dummy = -32*65536;
      enemy[enemy_no].vx = 0;
      enemy[enemy_no].vy = 0;
      enemy[enemy_no].tmp2 = 250;
      enemy[enemy_no].tmp3 = 0;
}

int Sio(enemy_no)
     int enemy_no;
{
      int i;
      int yararetaTL = 0;
      int dx,dy;
      int sx,sy;
      static int dox[2] = {-32,32};
      static int kuttuki = 0;

      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];

      dx = jx.sht[UNION]+dox[enemy[enemy_no].tmp1] - sx; 
      dy = jy.sht[UNION] - 48 - sy; 
      if(ABS(dx) < 5)
	dx = 0;
      if(ABS(dy) < 5)
	dy = 0;
      
      if(enemy[enemy_no].tmp2 > 0) {
	    enemy[enemy_no].tmp2 --;      
	    
	    enemy[enemy_no].x.sht[UNION] += SGN(dx)*8;
	    enemy[enemy_no].y.sht[UNION] += SGN(dy)*10;
	    SetSprite(enemy[enemy_no].x.sht[UNION],
		      enemy[enemy_no].y.sht[UNION],
		      pixmap[enemy[enemy_no].tmp2 % 4],
		      gc[enemy[enemy_no].tmp2 % 4],
		      CSIZE,CSIZE);	      

      } else {
	    if(enemy[enemy_no].tmp3 < ANIM_PAT) {
		  
		  enemy[enemy_no].x.sht[UNION] += SGN(dx)*4;
		  enemy[enemy_no].y.sht[UNION] += SGN(dy)*4;
		  
		  SetSprite(enemy[enemy_no].x.sht[UNION],
			    enemy[enemy_no].y.sht[UNION],
			    pixmap[anim[enemy[enemy_no].tmp1][enemy[enemy_no].tmp3]],
			    gc[anim[enemy[enemy_no].tmp1][enemy[enemy_no].tmp3]],
			    CSIZE,CSIZE);
		  enemy[enemy_no].tmp3++;
	    } else {
		  if(kuttuki < 16) {
			kuttuki++;
			if(enemy[enemy_no].tmp1) {
			      enemy[enemy_no].x.sht[UNION] -= 4;
			} else {
			      enemy[enemy_no].x.sht[UNION] += 4;
			}
			SetSprite(enemy[enemy_no].x.sht[UNION],
				  enemy[enemy_no].y.sht[UNION],
				  pixmap[enemy[enemy_no].tmp1*5+4+4],
				  gc[enemy[enemy_no].tmp1*5+4+4],
				  CSIZE,CSIZE);
		  } else {
			enemy[enemy_no].x.dummy += 0;
			enemy[enemy_no].y.dummy += -32*65536;
			
			SetSprite(enemy[enemy_no].x.sht[UNION],
                                  enemy[enemy_no].y.sht[UNION],
                                  pixmap[enemy[enemy_no].tmp1*5+4+4],
                                  gc[enemy[enemy_no].tmp1*5+4+4],
                                  CSIZE,CSIZE);
		  }
	    }
      }

      if(sy < -32) {
	    enemy[enemy_no].enemy_no = 0;
	    kuttuki = 0;
      }
      return 0;
}



