//
// $Id: city_rip.pov,v 1.1 1999/03/27 07:29:53 xblast Exp $
// $Log: city_rip.pov,v $
// Revision 1.1  1999/03/27 07:29:53  xblast
// Initial revision
//
//
#include "BLGeneric.inc"


#declare myDull = finish {ambient 0.2 specular 0.25 roughness 0.40}

#declare cutBox =
box {
  <-0.3,-0.3,-0.3>
  < 0.3, 0.3, 0.3>
}

difference {
  intersection {
    superellipsoid {<0.75,0.75>}
    plane { z,  1/3}
    plane {-z,  1/3}
    scale <1.9,2.5,1>
    translate <0,1.25,-5/3>
    pigment {
      marble 
      color_map {
        [0.0  color rgb <1.00,0.5,0.5>]
        [0.25 color rgb <1.00,0,0>]
        [1.0  color rgb <0.25,0,0>]
      }
      rotate z*45
      turbulence 0.5
    }
  }
  union {
    text { 
      ttf "timrom.ttf" "RODI" 0.2, 0
      scale <1.25,1.5,1.0>
      translate <-1.625,1.25,-2.1>
      pigment { rgb <1.25,0.75,0.75> }
    }
    object{cutBox rotate <45,45,00> translate <-1.90,0.00,-2> }
    object{cutBox rotate <45,45,00> translate <-1.90,3.00,-2> }
    object{cutBox rotate <45,00,45> translate <-0.25,3.75,-2> }
    object{cutBox rotate <00,45,45> translate < 1.00,3.50,-1.667> }
    object{cutBox rotate <45,45,45> translate < 1.90,2.00,-2> }
    pigment {
      marble 
      color_map {
        [0.0 color rgb <1.00,0,0>]
        [1.0 color rgb <0.25,0,0>]
      }
      rotate z*45
      turbulence 0.5
    }
  }
}

#declare stoneTile =
superellipsoid {
  <0.5, 0.5>
  translate -1.0*y
  scale <0.667,0.3,0.5>
  scale 0.95
  scale 0.50
  translate y*0.1
}

plane {
  y, -0.05
  pigment {color rgb <0.667,0.667,0.667>}
  normal {bumps 0.5}
}

#declare R1=seed(12345)


// stone tile

#declare tileGroup =
union {
// even row
#declare XP=-5/3
#while (XP < 2) 
  #declare ZP=-7/4
  #while (ZP < 2) 
    #declare YP=-0.1*rand(R1)
    object {
      stoneTile 
      translate <XP, YP, ZP>
      finish {myShiny}
      normal {bumps scale 0.25}
      pigment {color rgb <0,1,0> }
      #declare dummy=rand(R1)
    }    
    #declare ZP=ZP+1.0
  #end
  #declare XP=XP+2/3
#end
// odd row
#declare XP=-6/3
#while (XP < 5/3) 
  #declare ZP=-5/4
  #while (ZP < 2) 
    #declare YP=-0.1*rand(R1)
    object {
      stoneTile 
      translate <XP, YP, ZP>
      finish {myShiny}
      normal {bumps scale 0.25}
      pigment {color rgb <0,1,0> }
      #declare dummy=rand(R1)
    }    
    #declare ZP=ZP+1.0
  #end
  #declare XP=XP+2/3
#end
}


object {tileGroup}
object {tileGroup translate <-4,0, 0>}
object {tileGroup translate < 4,0, 0>}
object {tileGroup translate < 0,0, 4>}
object {tileGroup translate < 0,0,-4>}

