/*
 * Programm XBLAST V2.5.6 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * April 13th, 1997
 * started August 1993
 *
 * File: mystring.c 
 * somw string routines of my own
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mystring.c,v 1.1 1998/01/03 14:09:10 xblast Exp $
 * $Log: mystring.c,v $
 * Revision 1.1  1998/01/03 14:09:10  xblast
 * Initial revision
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define _MYSTRING_C
#include "include.h"
#include "mytypes.h"
#include "main.h"
#include "mystring.h"

/*
 * public function dup_string
 * (not all systems have strdup)
 */
#ifdef __STDC__
char *
dup_string (char* ptr, int length) 
#else
char *
dup_string (ptr, length)
     char *ptr;
     int length;
#endif
{
  char *result;

  if (NULL == (result = malloc((length+1)*sizeof(char) ) ) ) {
    return NULL;
  }
  strncpy(result, ptr, length);
  result[length] = '\0';
  return result;
}



/*
 * public function sep_string
 * (not all systems have strsep)
 */
#ifdef __STDC__
char *
sep_string (char *string, 
	    int sep)
#else
char *
sep_string (string, sep)
     char *string; 
     int sep;
#endif
{
  /* look for separator */
  for (; *string != (char) sep; string++) {
    /* check for end of string */
    if (*string == '\0') {
      return NULL;
    }
  }
  *string = '\0';
  /* return position of second string */
  return ++string;
}



/*
 * local function equal_string 
 */
#ifdef __STDC__
int
equal_string (char *s1, char *s2) 
#else
int
equal_string (s1, s2)
     char *s1, *s2;
#endif
{
  if (s1 == NULL) {
    if (s2 == NULL) {
      return 1;
    }
    return 0;
  } 
  if (s2 != NULL) {
    return (0 == strcmp(s1, s2));
  } else {
    return 0;
  }
}


/*
 * local function numeric_string
 */
#ifdef __STDC__
int
string_to_interval (char *string, 
		    int *left, 
		    int *right) 
#else
int
string_to_interval (string, left, right)
     char *string;
     int *left, *right;
#endif
{
  char *ptr;
  int flag = FALSE;

  for (ptr = string; *ptr != '\0'; ptr++) {
    if (!isdigit(*ptr)) {
      if (flag || ('-' != *ptr) ) {
	return -1;
      } 
      flag = TRUE;
    }
  }

  if (flag) {
    /* string is an interval */
    sscanf(string, "%d-%d", left,right);
  } else {
    /* string is single number */
    *left = *right = atoi (string);
  }

#if DEBUG
  fprintf(stderr, "Scanned interval [%d,%d]\n",*left, *right);
#endif
  return 0;
}


/*
 * local function numeric_string
 */
#ifdef __STDC__
int
numeric_string (char *ptr) 
#else
int
numeric_string (ptr)
     char *ptr;
#endif
{
  for (; *ptr != '\0'; ptr++) {
    if (!isdigit(*ptr)) {
      return 0;
    }
  }
  return 1;
}



/*
 * public function split_string
 */
#ifdef __STDC__
char ** 
split_string (char *string,
	      int *largc)
#else
char ** 
split_string (string, largc)
     char *string;
     int *largc;
#endif
{
  void *ptr;
  char *buf;
  char **argv;
  int i, flag, length, size, argc;

  /* get number of words */
  flag = TRUE;
  *largc = 0;
  size = 0;
  length = strlen(string);
  for (i=0; i<length; i++) {
    if (isspace(string[i])) {
      flag = TRUE;
    } else {
      if (flag) {
	(*largc) ++;
	flag = FALSE;
      }
      size ++;
    }
  }

  /* alloc array */
  if (NULL == (ptr = malloc( ((*largc)+1) * sizeof(char *) 
			    + (size+(*largc)) * sizeof(char) )) ) {
    fprintf(stderr, "string alloc failed\n");
    exit_prg(1);
  }
  
  /* now store strings */
  buf  = (char *) ((char **)ptr + ((*largc)+1));
  argv = (char **) ptr;
  argc = 0;
  flag=TRUE;
  for (i=0; i<length; i++) {
    if (isspace(string[i])) {
      if (!flag) {
	flag = TRUE;
	*buf = '\0';
	buf++;
      }
    } else {
      if (flag) {
	argv[argc]=buf;
	argc++;
	flag = FALSE;
      }
      *buf = string[i];
      buf++;
    }
  }
  *buf='\0';
  argv[argc]=NULL;

  return argv;
}

/*
 * end of file mystring.c
 */
