/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardPutKey.cpp
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#include "xcardMain.h"
#include "xcardPutKey.h"
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

#define XC_RIDICULOUS_KEYSIZE 6000

unsigned char bigKeyBuffer[XC_RIDICULOUS_KEYSIZE];

#define Inherited xcardPutKeyData

xcardPutKey::xcardPutKey
(
 MSCLPTokenConnection pConn,
 xcardMain *mainWin,
 QWidget* parent,
 const char* name
)
	:
	Inherited( parent, name )
{

  mainWindow    = mainWin;
  pConnect      = pConn;
  onFirstScreen = TRUE;
}

xcardPutKey::~xcardPutKey()
{
}

int xcardPutKey::XCInitializeKeyDialog( bool generateKey,
					bool reGenerateKey,
					MSCLong32 choiceKey ) {

  MSCLong32 rv;
  MSCKeyInfo keyInf;
  unsigned char keysUsed[MSC_MAX_KEYS];
  char tempBuffer[50];
  QString backupFile;
  MSCUShort16 pinInf;
  int lastSlash;
  int i, p;

  isGenerate      = generateKey;
  isReGenerate    = reGenerateKey; 
  choiceKeyNumber = choiceKey;
  isFileOK        = FALSE;

  for (i=0; i<MSC_MAX_KEYS; i++) {
    keysUsed[i] = 0x00;
  }

  if ( generateKey == FALSE ) {
    g_putKeyLabel1->setText("Import Key from File");
    onFirstScreen = TRUE;

    importFile = QFileDialog::getOpenFileName(".", "*");
    
    if ( importFile.isNull() ) {
      printf("NULL Filename\n");
      return -1;
    }
    
    backupFile = importFile;
    lastSlash  = backupFile.findRev('/');
    
    if ( lastSlash != -1 ) {
      backupFile.remove(0, lastSlash+1);
    } else {
      /* do nothing */
    }
    
    g_putKeyFileSelectLabel1->setText(backupFile);
    isFileOK = TRUE;

  } else {
    /* Generate Key == TRUE */

    onFirstScreen = TRUE;
    g_putKeyLabel1->setText("Generate Private Parameters");
    g_putKeySizeBox1->setCurrentItem(1);
  }

  if ( choiceKeyNumber >= 0 ) {
    g_putKeyNumberBox1->clear();
    snprintf(tempBuffer, sizeof(tempBuffer), "KEY #%ld", choiceKeyNumber);
    g_putKeyNumberBox1->insertItem(tempBuffer);
  } else {

    rv = MSCListKeys( pConnect, MSC_SEQUENCE_RESET, &keyInf );
    
    while ( rv == MSC_SUCCESS ) {
      keysUsed[keyInf.keyNum] = 1;
      rv = MSCListKeys( pConnect, MSC_SEQUENCE_NEXT, &keyInf );
    }    
    
    g_putKeyNumberBox1->clear();

    for (i=0; i<MSC_MAX_KEYS; i++) {
      
      if ( isReGenerate == TRUE ) {
	if ( keysUsed[i] == 1 ) {
	  snprintf(tempBuffer, sizeof(tempBuffer), "KEY #%d", i);
	  g_putKeyNumberBox1->insertItem(tempBuffer);
	}
      } else {
	if ( keysUsed[i] == 0 ) {
	  snprintf(tempBuffer, sizeof(tempBuffer), "KEY #%d", i);
	  g_putKeyNumberBox1->insertItem(tempBuffer);
	}
      }
    }    
  }

  if ( isGenerate == TRUE ) {
    g_putKeyTypeLabel1->setEnabled(TRUE);
    g_putKeySizeLabel1->setEnabled(TRUE);
    g_putKeyTypeBox1->setEnabled(TRUE);
    g_putKeySizeBox1->setEnabled(TRUE);
    g_putKeyFileSelectLabel1->setEnabled(FALSE);
    g_putKeyFileSelectLabel1->setText("");
  } else {
    g_putKeyTypeLabel1->setEnabled(FALSE);
    g_putKeySizeLabel1->setEnabled(FALSE);
    g_putKeyTypeBox1->setEnabled(FALSE);
    g_putKeySizeBox1->setEnabled(FALSE);
    g_putKeyFileSelectLabel1->setEnabled(TRUE);
  }

  g_putKeyFileSelectLabel1->setAlignment(QLabel::AlignRight);

  g_readPermCombo1->clear();
  g_writePermCombo1->clear();
  g_usagePermCombo1->clear();

  g_readPermCombo1->insertItem("Allowed");
  g_writePermCombo1->insertItem("Allowed");
  g_usagePermCombo1->insertItem("Allowed");

  g_readPermCombo1->insertItem("UnAllowed");
  g_writePermCombo1->insertItem("UnAllowed");
  g_usagePermCombo1->insertItem("UnAllowed");


  rv = MSCListPINs( pConnect, &pinInf );
  
  p=0; 

  for (i=1; i < 0xFFFF; i <<= 1) {
    if (pinInf & i) {
      snprintf(tempBuffer, sizeof(tempBuffer), "PIN #%d", p);
      g_readPermCombo1->insertItem(tempBuffer);
      g_writePermCombo1->insertItem(tempBuffer);
      g_usagePermCombo1->insertItem(tempBuffer);
    }

    ++p;
  }
  
  rv = MSCListKeys( pConnect, MSC_SEQUENCE_RESET, &keyInf );
  p  = 0;
  
  while ( rv == MSC_SUCCESS ) {
    if ( keyInf.keyNum <= 5 ) {
      snprintf(tempBuffer, sizeof(tempBuffer), "KEY #%d", keyInf.keyNum);
      g_readPermCombo1->insertItem(tempBuffer);
      g_writePermCombo1->insertItem(tempBuffer);
      g_usagePermCombo1->insertItem(tempBuffer);
      rv = MSCListKeys( pConnect, MSC_SEQUENCE_NEXT, &keyInf );
      ++p;
    }
  }    


  g_readPermCombo1->setSelected(0, TRUE);
  g_writePermCombo1->setSelected(0, TRUE);
  g_usagePermCombo1->setSelected(0, TRUE);

  return 0;
}

void xcardPutKey::XCKeyTypeChanged(const QString&)
{
}

void xcardPutKey::XCOKPutKeyClicked()
{
  MSCLong32 rv;
  char tempString[200];
  MSCULong32 chosenNumber;
  MSCKeyACL keysACL;
  MSCKeyPolicy keyPolicy;
  //MSCULong32 keySize;
  //MSCULong32 keyType;
  int ret;

  if (isGenerate == FALSE) {
    do {
      QString keyNumber = g_putKeyNumberBox1->currentText();
      strcpy((char *)tempString, keyNumber.latin1());
      
      chosenNumber = strtoul((char *)&tempString[5], 0, 10);  
      
      /* TODO : permissions */
      
      QFile inFile(importFile);
      
      if ( inFile.exists() == FALSE ) {
	hide();
	QMessageBox::critical( 0, "XCard II",
			      "File doesn't Exist" );
	break;
      }
      
      inFile.open(IO_ReadOnly);

      if ( inFile.size() > XC_RIDICULOUS_KEYSIZE ) {
	hide();
	QMessageBox::critical( 0, "XCard II",
			      "File too Big" );
	break;
      }

      ret = inFile.readBlock((char *)bigKeyBuffer, inFile.size());

      if ( ret == -1 ) {
	printf("Can't read\n");
	hide();
	QMessageBox::critical( 0, "XCard II",
			      "Error Reading File" );
	break;
      }

      inFile.close();

      keysACL.readPermission  = MSC_AUT_ALL;
      keysACL.writePermission = MSC_AUT_ALL;
      keysACL.usePermission   = MSC_AUT_ALL;

      rv = MSCImportKey(pConnect, chosenNumber, &keysACL, bigKeyBuffer,
			inFile.size(), &keyPolicy, 0, 0);

      if ( rv == MSC_SUCCESS ) {
	hide();
	QMessageBox::information( 0, "XCard II",
				  "Key Import Successful" );
      } else  {
	snprintf(tempString, sizeof(tempString), "Import Key Failed\nCode:%s",
		 msc_error(rv));
	hide();
	QMessageBox::critical( 0, "XCard II",
			      tempString );
	break;
      }

      mainWindow->XCUpdateList();

    } while (0);

  } else {
    /* Must be a generate key command */

    do {
      
      if ( onFirstScreen == TRUE ) {
	QString prvKeyNumber = g_putKeyNumberBox1->currentText();
	strcpy((char *)tempString, prvKeyNumber.latin1());
	
	/* Params - Private Key Number */
	prvKeyIndex  = g_putKeyNumberBox1->currentItem();
	chosenNumber = strtoul((char *)&tempString[5], 0, 10); 
        prvKeyNum    = chosenNumber;
	
	/* TODO : The ACL stuff */
	
	/* Params - Private Key ACL */
	pKeyParams.privateKeyACL.readPermission  = MSC_AUT_ALL;
	pKeyParams.privateKeyACL.writePermission = MSC_AUT_ALL;
	pKeyParams.privateKeyACL.usePermission   = MSC_AUT_ALL;
	
	g_putKeyLabel1->setText("Generate Public Parameters");
	g_putKeyNumberBox1->removeItem(prvKeyIndex);
	g_putKeyNumberBox1->setCurrentItem(
	     g_putKeyNumberBox1->currentItem()+1);
	g_putKeyTypeLabel1->setEnabled(FALSE);
	g_putKeySizeLabel1->setEnabled(FALSE);
	g_putKeyTypeBox1->setEnabled(FALSE);
	g_putKeySizeBox1->setEnabled(FALSE);     
	
	onFirstScreen = FALSE;
	
      } else {

	QString pubKeyNumber = g_putKeyNumberBox1->currentText();
	strcpy((char *)tempString, pubKeyNumber.latin1());
	
	/* Public Key Number */
	chosenNumber = strtoul((char *)&tempString[5], 0, 10); 
	pubKeyNum = chosenNumber;

	QString keySizeStr = g_putKeySizeBox1->currentText();
	strcpy((char *)tempString, keySizeStr.latin1());
	
	/* Params - Key Size, Algorithm */
	pKeyParams.keySize  = strtoul((char *)tempString, 0, 10); 
	pKeyParams.algoType = MSC_GEN_ALG_RSA_CRT;

	/* TODO : The ACL stuff */
	
	/* Params - Public Key ACL */
	pKeyParams.publicKeyACL.readPermission  = MSC_AUT_ALL;
	pKeyParams.publicKeyACL.writePermission = MSC_AUT_ALL;
	pKeyParams.publicKeyACL.usePermission   = MSC_AUT_ALL;

	/* Params - Options, Parameters, Size */
	pKeyParams.keyGenOptions  = MSC_OPT_DEFAULT;
	pKeyParams.pOptParams     = 0;
	pKeyParams.optParamsSize  = 0;

	QMessageBox::information( 0, "XCard II",
			         "Note: Key generation may\ntake some time and may\ncause some Windows to freeze" );

	rv = MSCGenerateKeys(pConnect, prvKeyNum, pubKeyNum, &pKeyParams);


	if ( rv == MSC_SUCCESS ) {
	  mainWindow->XCUpdateList();
	  hide();
	  QMessageBox::information( 0, "XCard II",
				    "Key Generation Successful" );
	} else {
	  snprintf(tempString, sizeof(tempString), "Generate Failed\nCode:%s",
		   msc_error(rv));
	  hide();
	  QMessageBox::critical( 0, "XCard II",
				 tempString );
	}

	g_putKeyTypeLabel1->setEnabled(TRUE);
	g_putKeySizeLabel1->setEnabled(TRUE);
	g_putKeyTypeBox1->setEnabled(TRUE);
	g_putKeySizeBox1->setEnabled(TRUE); 
	onFirstScreen = TRUE;
      }

    } while (0);


  }

}

void xcardPutKey::XCCancelPutKeyClicked()
{
  hide();
}

void xcardPutKey::XCKeySizeSelected(int)
{
}
