#! /bin/sh
# main.tcl
# $Id: main.tcl,v 1.17 2001/03/19 01:01:46 golem Exp $
# The entry point for xed.
#
#
# XED --- an X-enabled implementation of ed, the standard editor.
# Copyright (C) 1999  Chris Laas
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# Chris Laas
# golem@mit.edu
# 22 Pratt Court
# Cohasset, MA 02025 USA
#
#
# The next lines bootstrap us into wish or tclsh. \
trap "" 21 ;\
TCLSH=tclsh ;\
for ver in 8.3 8.2 8.1 ; do \
 if type tclsh$ver >/dev/null 2>&1 ; then TCLSH=tclsh$ver ; break ; fi ;\
done ;\
WISH=wish ;\
for ver in 8.3 8.2 8.1 ; do \
 if type wish$ver >/dev/null 2>&1 ; then WISH=wish$ver ; break ; fi ;\
done ;\
if [ x$DISPLAY = x ]; then exec $TCLSH $0 -ttymode "$@" ; fi ;\
for arg in "$@" ; do \
 if [ x$arg = x-t -o x$arg = x-ttymode ]; then exec $TCLSH $0 "$@" ; fi ;\
done ;\
exec $WISH $0 "$@"

##########################
# The tcl code begins here.

set VERSION 0.9.1



if {$tcl_version < 8.1} {
    error "xed requires at least TCL version 8.1 to run properly."
}



set is_tclet [info exists embed_args]
if $is_tclet { proc wm args {} }


##########################
# Command line handling.
set verbose 1
set prompt ""

set backup_files 1
set playback 0
set ttymode 0
set debug 0
set init_file ""

proc usage {} {
	puts {Usage: xed [OPTION]... [FILE]

  -s                 suppress diagnostics
  -p STRING          use STRING as an interactive prompt

  -nb                don't back up files before save
  -P                 go into playback mode: read lines from stdin into GUI
  -ttymode           do not start up X GUI
  -fn FONT           use FONT for GUI
  -x N               set tab stops at every N spaces in GUI
  -nwl               don't wrap lines in GUI
  -nsb               don't show scrollbar in GUI
  -help              display this help
  -version           output version information

Starts editing with the command "e FILE" if given.}
}

set skipnext 0
foreach arg1 $argv arg2 [lrange $argv 1 end] {
	if $skipnext { set skipnext 0 ; continue }
	switch -glob -- $arg1 {
		-s { set verbose 0 }
		-p { set prompt $arg2 ; set skipnext 1 }

		-nb      { set backup_files 0 }
		-P       { set playback 1 }
		-ttymode { set ttymode 1 ; set line_source tty }
		-fn      { option add *font $arg2 interactive ; set skipnext 1 }
		-x       { option add *tabWidth $arg2 interactive ; set skipnext 1 }
		-nwl     { option add *wrapLines off interactive }
		-nsb     { option add *scrollbar off interactive }
		-debug   { set debug 1 }
		-bgerror { proc bgerror {msg} { puts stderr $msg } }
		-help    { usage ; exit 0 }
		-version { puts "xed version $VERSION" }
		-* {
			puts stderr "xed: Unrecognized option \"$arg1\""
			puts stderr "Try \"xed -help\" for more information."
			exit 1
		}
		default { set init_file $arg1 }
	}
}

if {$playback && $ttymode} {
	puts stderr "xed: Cannot do playback in ttymode.  Aborting."
	exit 1
}



##############################################################
# Here we have the files which contain the real guts of xed.
source "parse.tcl"
source "command.tcl"
source "nonstd-cmds.tcl"
source "buffer.tcl"
source "regexp.tcl"



##########################
# Initialization.
buffer-init

if {!$debug} { proc bgerror {message} { puts-error $message } }

if {$init_file != ""} { process-line "E $init_file" }
if {!$is_tclet} { puts -nonewline $prompt }

##########################
# Playback mode.
if $playback {
	while {![eof stdin]} {
		gets stdin entry_line ; raise .e
		while {$entry_line != {}} { vwait entry_line }
	}
	exit 0
}


##########################
# Enter event loop in tty mode.
vwait variable_never_set
