/*                             */
/* xemeraldia   --- graphics.c */
/*                             */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "games.h"

static void printStar(int x, int y);
static gboolean animateTmpScore (void *);

guint timer, tmp_sc_timer;
PangoFontDescription *animated_score_font, *game_over_font, *pause_font;

struct TmpSc
{
	long sc;
	int  x, y;
	char cnt;
};

static struct TmpSc  tmpSc[50];


void  RedrawBoard (GtkWidget *w)
{
  if (! paused)
    {
      gdk_draw_drawable(w->window, draw_gc, board_pix, 0, 0, 0, 0, WIN_WIDTH, WIN_HEIGHT);
    }
  else
    {
	PangoLayout *layout;
	PangoRectangle rect;
	gdk_draw_rectangle(w->window, delete_gc, TRUE, 0, 0,
		WIN_WIDTH, WIN_HEIGHT);

	gdk_draw_rectangle(w->window, draw_gc, FALSE, DIFF_X / 2, DIFF_Y / 2,
		  BLOCK_WIDTH * BOARD_WIDTH + DIFF_X,
		  BLOCK_HEIGHT * BOARD_HEIGHT + DIFF_Y);

	layout = gtk_widget_create_pango_layout (board_w, _("PAUSE!"));
	pango_layout_set_font_description(layout, pause_font);
	pango_layout_get_pixel_extents(layout, &rect, NULL);
	gdk_draw_layout(board_w->window, draw_gc,
		(WIN_WIDTH/2)-(rect.width/2), 220, layout);
	g_object_unref (layout);
    }
}


void  RedrawNextItem ()
{
  clearNextItem ();
  if ((! gameover_flag) && (! paused))
    printNextItem ();
}


void  showTmpScore (long tmp_sc, int sc_x, int sc_y, long ch_s)
{
  PangoLayout *layout;
  char  tmp_sc_str[8];

  tmpSc[ch_s].x = sc_x;  tmpSc[ch_s].y = sc_y;
  tmpSc[ch_s].sc = tmp_sc;
  tmpSc[ch_s].cnt = 8;
  sprintf (tmp_sc_str, "%7ld", tmpSc[ch_s].sc);

	layout = gtk_widget_create_pango_layout (board_w, tmp_sc_str);
	pango_layout_set_font_description(layout, animated_score_font);
	gdk_draw_layout(board_w->window, draw_gc,
		(tmpSc[ch_s].x - 1) * BLOCK_WIDTH - 6,
		((tmpSc[ch_s].y + 1) * BLOCK_HEIGHT - 24 + tmpSc[ch_s].cnt * 3) - 25,
		layout);
	g_object_unref (layout);
  gdk_flush();

  gdk_flush();
  --tmpSc[ch_s].cnt;
  tmp_sc_timer = g_timeout_add(20, animateTmpScore, GINT_TO_POINTER(ch_s));
}


static gboolean animateTmpScore(void *closure)
{
  gint ch_s = GPOINTER_TO_INT(closure);
  PangoLayout *layout;
  char  tmp_sc_str[8];

      gdk_draw_drawable(board_w->window, draw_gc, board_pix,
		(tmpSc[ch_s].x - 1) * BLOCK_WIDTH,
		(tmpSc[ch_s].y + 1) * BLOCK_HEIGHT - 43 + tmpSc[ch_s].cnt * 3,
		(tmpSc[ch_s].x - 1) * BLOCK_WIDTH,
		(tmpSc[ch_s].y + 1) * BLOCK_HEIGHT - 43 + tmpSc[ch_s].cnt * 3,
		90, 25);

  gdk_flush();

  sprintf (tmp_sc_str, "%7ld", tmpSc[ch_s].sc);

	layout = gtk_widget_create_pango_layout (board_w, tmp_sc_str);
	pango_layout_set_font_description(layout, animated_score_font);
	gdk_draw_layout(board_w->window, draw_gc,
		(tmpSc[ch_s].x - 1) * BLOCK_WIDTH - 6,
		((tmpSc[ch_s].y + 1) * BLOCK_HEIGHT - 24 + tmpSc[ch_s].cnt * 3) - 25,
		layout);
	g_object_unref (layout);
	gdk_flush();

	if (--tmpSc[ch_s].cnt > 0)
		tmp_sc_timer = g_timeout_add(45, animateTmpScore, GINT_TO_POINTER(ch_s));
	else
		gdk_draw_drawable(board_w->window, draw_gc, board_pix,
			(tmpSc[ch_s].x - 1) * BLOCK_WIDTH,
			(tmpSc[ch_s].y + 1) * BLOCK_HEIGHT - 43 + tmpSc[ch_s].cnt * 3,
			(tmpSc[ch_s].x - 1) * BLOCK_WIDTH,
			(tmpSc[ch_s].y + 1) * BLOCK_HEIGHT - 43 + tmpSc[ch_s].cnt * 3,
			90, 25);
	return FALSE;
}


void  clearNextItem ()
{
	gdk_draw_rectangle(nextItem_w->window, delete_gc, TRUE, 0, 0,
		BLOCK_WIDTH * 3, BLOCK_HEIGHT * 3);
}


void  printNextItem ()
{
  int  i;

  clearNextItem ();
  if (next_i.col[0] == STAR)
      gdk_draw_drawable(nextItem_w->window, draw_gc, star, 0, 0,
			BLOCK_WIDTH / 2 + DIFF_X, BLOCK_HEIGHT /2 + DIFF_Y,
			BLOCK_WIDTH, BLOCK_HEIGHT);
  else
    {
      for (i = 0; i < 3; i++)
      gdk_draw_drawable(nextItem_w->window, draw_gc, block[next_i.col[i]], 0, 0,
			BLOCK_WIDTH * (iRot_vx[0][i]) + DIFF_X,
			BLOCK_HEIGHT * (1 + iRot_vy[0][i]) + DIFF_Y,
			BLOCK_WIDTH, BLOCK_HEIGHT);
    }
}


void clearScreen()
{
	gdk_draw_rectangle(board_pix, delete_gc, TRUE, 0, 0,
		WIN_WIDTH, WIN_HEIGHT);

	gdk_draw_rectangle(board_pix, draw_gc, FALSE, DIFF_X / 2, DIFF_Y / 2,
		  BLOCK_WIDTH * BOARD_WIDTH + DIFF_X,
		  BLOCK_HEIGHT * BOARD_HEIGHT + DIFF_Y);
}


void  printItem ()
{
  int  i;

  if (star_comes)
    printStar (drop_i.x, drop_i.y);
  else
    for (i = 0; i < 3; i++)
      {
	printBlock (drop_i.x + iRot_vx[drop_i.rot][i],
		    drop_i.y + iRot_vy[drop_i.rot][i],
		    drop_i.col[i]);
	board[drop_i.x + iRot_vx[drop_i.rot][i]]
          [drop_i.y + iRot_vy[drop_i.rot][i]].blk = drop_i.col[i];
      }
}


void printBlock(int x, int y, cellstatus_t color)
{
  int  pixmap_number;

  if ((board[x][y].sub == CRACKED) || (board[x][y].sub == DELETE))
    pixmap_number = color + BLOCK_VARIETY;
  else  pixmap_number = color;
  if ((color > 0) && (color <= BLOCK_VARIETY * 2))
    {
      gdk_draw_drawable(board_pix, draw_gc, block[pixmap_number], 0, 0,
		BLOCK_WIDTH * x - DIFF_X, BLOCK_HEIGHT * y + DIFF_Y,
		BLOCK_WIDTH, BLOCK_HEIGHT);
      gdk_draw_drawable(board_w->window, draw_gc, block[pixmap_number], 0, 0,
		BLOCK_WIDTH * x - DIFF_X, BLOCK_HEIGHT * y + DIFF_Y,
		BLOCK_WIDTH, BLOCK_HEIGHT);
    }
}


void  deleteBlocks ()
{
  int  x, y;

  for (x = 1; x <= BOARD_WIDTH; x++)
    for (y = 0; y <= BOARD_HEIGHT; y++)
      if (board[x][y].sub == DELETE)
	{
	  delete_1_block (x, y);
	  board[x][y].blk = EMPTY;
	  board[x][y].sub = EMPTY_SUB;
	}
}


void  delete_1_block (int x, int y)
{
	gdk_draw_rectangle(board_pix, delete_gc, TRUE,
		BLOCK_WIDTH * x - DIFF_X, BLOCK_WIDTH * y + DIFF_Y,
		BLOCK_WIDTH, BLOCK_WIDTH);
	gdk_draw_rectangle(board_w->window, delete_gc, TRUE,
		BLOCK_WIDTH * x - DIFF_X, BLOCK_WIDTH * y + DIFF_Y,
		BLOCK_WIDTH, BLOCK_WIDTH);
}


void  startTimer ()
{
  int  reduce;

  if (blocks < 200)  reduce = (blocks / 20) * 70;
  else  if (blocks < 400) reduce = ((blocks - 200) / 20) * 50;
  else  if (blocks < 600) reduce = 500 + ((blocks - 400) / 20) * 25;
  else  if (blocks < 800) reduce = 200 + ((blocks - 600) / 20) * 50;
  else  if (blocks < 1000) reduce = 700 + ((blocks - 800) / 20) * 10;
  else  reduce = 860;

  if (star_comes)  reduce = 0;

  timer = g_timeout_add(MAX_DELAY - reduce, (GSourceFunc)DropItem, NULL);
}


void  stopTimer ()
{
	g_source_remove(timer);
	timer = 0;
}


void  printScore ()
{
  char  buf[30];

  sprintf (buf, "%7ld", sc);
  gtk_label_set_label(GTK_LABEL(score_disp), buf);
}


void  printLevel ()
{
  char  buf[30];

  sprintf (buf, "%7ld", blocks / 20 + 1);
  gtk_label_set_label(GTK_LABEL(level_disp), buf);
}


void  Done ()
{
}


void crack_1_block(int x, int y)
{
  if ((board[x][y].blk > 0) && (board[x][y].blk <= BLOCK_VARIETY))
    {
      gdk_draw_drawable(board_pix, draw_gc, block[board[x][y].blk + BLOCK_VARIETY], 0, 0,
			BLOCK_WIDTH * x - DIFF_X, BLOCK_HEIGHT * y + DIFF_Y,
			BLOCK_WIDTH, BLOCK_HEIGHT);
      gdk_draw_drawable(board_w->window, draw_gc, block[board[x][y].blk + BLOCK_VARIETY], 0, 0,
			BLOCK_WIDTH * x - DIFF_X, BLOCK_HEIGHT * y + DIFF_Y,
			BLOCK_WIDTH, BLOCK_HEIGHT);
    }
}


void  crushAnimate (int x, int y, int num)
{
      gdk_draw_drawable(board_pix, draw_gc, crush[num], 0, 0,
			BLOCK_WIDTH * x - DIFF_X, BLOCK_HEIGHT * y + DIFF_Y,
			BLOCK_WIDTH, BLOCK_HEIGHT);
      gdk_draw_drawable(board_w->window, draw_gc, crush[num], 0, 0,
			BLOCK_WIDTH * x - DIFF_X, BLOCK_HEIGHT * y + DIFF_Y,
			BLOCK_WIDTH, BLOCK_HEIGHT);
}


static void  printStar (int x, int y)
{
	gdk_draw_drawable(board_pix, draw_gc, star,
		0,0,
		BLOCK_WIDTH * x - DIFF_X, BLOCK_HEIGHT * y + DIFF_Y,
		BLOCK_WIDTH, BLOCK_HEIGHT);
	gdk_draw_drawable(board_w->window, draw_gc, star,
		0,0,
		BLOCK_WIDTH * x - DIFF_X, BLOCK_HEIGHT * y + DIFF_Y,
		BLOCK_WIDTH, BLOCK_HEIGHT);
}
