#!/usr/bin/env python
#
#   XenMan   -  Copyright (c) 2006 Jd & Hap Hazard
#   ======
#
# XenMan is a Xen management tool with a GTK based graphical interface
# that allows for performing the standard set of domain operations
# (start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
# also attempts to simplify certain aspects such as the creation of
# domains, as well as making the consoles available directly within the
# tool's user interface.
#
#
# This software is subject to the GNU Lesser General Public License (LGPL)
# and for details, please consult it at:
#
#    http://www.fsf.org/licensing/licenses/lgpl.txt
#


# _RESTRUCTURING
# from _restructuring import ManagedNode
# _RESTRUCTURING

from ManagedNode import ManagedNode

class GridManager:

    def __init__(self):        
        self.node_list = {}
            
    
    def discoverNodes(self,ip_list):
        pass



    def getNodeNames(self):
        return self.node_list.keys()

    def getNodeList(self):
        return self.node_list

    def getNode(self,name):
        return self.node_list[name]

    
    def addNodeName(self, name):
        if name not in self.node_list:
            self.node_list[name] = None
    
    def addNode(self,node):
        self.node_list[node.hostname] = node

    def removeNode(self,name):
        del self.node_list[name]

    def isInitialised(self, name):
        if name in self.node_list and \
               self.getNode(name) is not None:
            return True
        else:
            return False
        


    def cloneNode(self,source_node, dest):
        pass

    def migrateNode(self,source_node, dest):
        pass

    def cloneDomain(self,source_dom_name,
                    source_node,
                    dest_node=None):
        pass
    
    def migrateDomain(self,source_dom_name,
                      source_node,
                      dest_node):
        pass


