Summary: A graphical Xen management tool
Name: xenman
Version: 0.5
License: GPL
Group: Applications/System
Packager: Haphazard <haphazard1@users.sourceforge.net>
URL: http://xenman.sourceforge.net/
BuildArchitectures: noarch
Source: http://prdownloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
%if "%{_vendor}" == "suse"
Release: 1.suse
Requires: python >= 2.4, xen >= 3.0.2, python-gtk, vte, rpm-python, python-curses
Requires: install-initrd
Requires: python-paramiko >= 1.6.1
%define distext suse
%else
Release: 1.fc5
Requires: python >= 2.4, xen >= 3.0.2, pygtk2, vte, rpm-python
Requires: python-paramiko >= 1.6.1
%define distext fedora
%endif

%description
XenMan is a Xen management tool with a GTK based graphical interface
that allows for performing the standard set of domain operations
(start, stop, pause, kill, shutdown, reboot, snapshot, etc...). It
also attempts to simplify certain aspects such as the creation of
domains, as well as making the consoles available directly within the
tool's user interface.

%prep
%setup -q

%install
[ %{buildroot} != / ] && %{__rm} -rf %{buildroot}

%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/pixmaps
%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/doc
%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/patches
%{__mkdir_p} %{buildroot}%{_datadir}/%{name}/src
%{__mkdir_p} %{buildroot}%{_localstatedir}/cache/%{name}
%{__mkdir_p} %{buildroot}%{_bindir}

%{__install} -Dp -m0644 %{name}.conf-%{distext} %{buildroot}%{_sysconfdir}/%{name}.conf

%{__install} -Dp -m0644 src/* %{buildroot}%{_datadir}/%{name}/src
%{__chmod} 0755 %{buildroot}%{_datadir}/%{name}/src/%{name}.py

%{__install} -Dp -m0644 %{name}.glade %{buildroot}%{_datadir}/%{name}/%{name}.glade
%{__install} -Dp -m0644 pixmaps/* %{buildroot}%{_datadir}/%{name}/pixmaps
%{__install} -Dp -m0644 doc/* %{buildroot}%{_datadir}/%{name}/doc
%{__install} -Dp -m0644 patches/* %{buildroot}%{_datadir}/%{name}/patches
%{__chmod} 0544 %{buildroot}%{_datadir}/%{name}/patches/patch_paramiko

%{__ln_s} ../share/%{name}/src/%{name}.py %{buildroot}%{_bindir}/%{name}

%if "%{_vendor}" == "suse"
%{__install} -p -m0755 configure_defaults-suse.sh %{buildroot}%{_datadir}/%{name}/
%endif

%clean
[ %{buildroot} != / ] && %{__rm} -rf %{buildroot}

%if "%{_vendor}" == "suse"
%post
if [ "$1" = 1 ]; then
  %{_datadir}/%{name}/configure_defaults-suse.sh > /dev/null
fi

%preun
if [ "$1" = 0 ]; then
  %{__rm} -rf %{_localstatedir}/cache/%{name}/*
fi
%endif

%files
%defattr(-,root,root,-)
%doc doc/* 
%config %{_sysconfdir}/%{name}.conf
%{_bindir}/%{name}
%{_datadir}/%{name}
%dir %{_localstatedir}/cache/%{name}

%changelog
* Thu Sep 28 2006 Haphazard <haphazard1@users.sourceforge.net> 0.5-1
- new version

* Thu Aug 24 2006 Jd <jd_jedi@users.sourceforge.net> 0.4.2.2
- hotfix for start up problem.

* Sun Aug 13 2006 Haphazard <haphazard1@users.sourceforge.net> 0.4.2-1
- extended SUSE dependency list.

* Tue Jul 25 2006 Yves Perrenoud <yves@xpand.org> 0.4.1-2
- added some SUSE specific elements to ultimately support the post-install
  creating of an install initial ramdisk
- now marks the config file as one

* Mon Jul 24 2006 Yves Perrenoud <yves@xpand.org> 0.4.1-1
- new version
- added Suse support

* Wed Jul 19 2006 Yves Perrenoud <yves@xpand.org> 0.4-1
- new version
- added the change log to the doc files

* Thu Jun 8 2006 Yves Perrenoud <yves@xpand.org> 0.3-1
- Initial build.
