/*
 *	xeno_style_draw.h
 */

#ifndef XENO_STYLE_DRAW_H
#define XENO_STYLE_DRAW_H

#include <gtk/gtkstyle.h>

#if XENO_GTK2
typedef const gchar		xeno_char;
#else
typedef gchar			xeno_char;
#endif

void    xeno_style_draw_hline			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x1,
										 gint			x2,
										 gint			y);

void    xeno_style_draw_vline			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			y1,
										 gint			y2,
										 gint			x);

void    xeno_style_draw_shadow			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_polygon			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 GdkPoint		*point,
										 gint			npoints,
										 gint			fill);

void    xeno_style_draw_arrow			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 GtkArrowType	arrow_type,
										 gint			fill,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_diamond			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_oval			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_string			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 const gchar	*string);

void    xeno_style_draw_box				(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_flat_box		(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_check			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_option			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_cross			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_ramp			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 GtkArrowType	arrow_type,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_tab				(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_shadow_gap		(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height,
										 GtkPositionType gap_side,
										 gint			gap_x,
										 gint			gap_width);

void    xeno_style_draw_box_gap			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height,
										 GtkPositionType gap_side,
										 gint			gap_x,
										 gint			gap_width);

void    xeno_style_draw_extension		(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height,
										 GtkPositionType gap_side);

void    xeno_style_draw_focus			(GtkStyle		*style,
										 GdkWindow		*window,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height);

void    xeno_style_draw_slider			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height,
										 GtkOrientation	orientation);

void    xeno_style_draw_handle			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 GtkShadowType	shadow_type,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 xeno_char		*detail,
										 gint			x,
										 gint			y,
										 gint			width,
										 gint			height,
										 GtkOrientation	orientation);

#if XENO_GTK2
void	xeno_style_draw_layout			(GtkStyle		*style,
										 GdkWindow		*window,
										 GtkStateType	state_type,
										 gboolean		use_text,
										 GdkRectangle	*area,
										 GtkWidget		*widget,
										 const gchar	*detail,
										 gint			x,
										 gint			y,
										 PangoLayout	*layout);
#endif

#endif /* XENO_STYLE_DRAW_H */

